/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.captcha;

import cn.hutool.core.io.IoUtil;
import cn.morethank.open.admin.common.captcha.CaptchaRandom;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class PngCaptcha {
    private Font font = new Font("Verdana", 3, 28);
    private int len = 5;
    private int width = 150;
    private int height = 40;
    private String chars = null;

    public PngCaptcha() {
    }

    public PngCaptcha(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public PngCaptcha(int width, int height, int len) {
        this(width, height);
        this.len = len;
    }

    public PngCaptcha(int width, int height, int len, Font font) {
        this(width, height, len);
        this.font = font;
    }

    public void out(OutputStream out) {
        this.graphicsImage(this.alphas(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean graphicsImage(char[] strs, OutputStream out) {
        boolean ok = false;
        try {
            Color color;
            BufferedImage bi = new BufferedImage(this.width, this.height, 1);
            Graphics2D g = (Graphics2D)bi.getGraphics();
            int len = strs.length;
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.width, this.height);
            for (int i = 0; i < 15; ++i) {
                color = this.color(150, 250);
                g.setColor(color);
                g.drawOval(CaptchaRandom.num(this.width), CaptchaRandom.num(this.height), 5 + CaptchaRandom.num(10), 5 + CaptchaRandom.num(10));
                color = null;
            }
            g.setFont(this.font);
            int h = this.height - (this.height - this.font.getSize() >> 1);
            int w = this.width / len;
            int size = w - this.font.getSize() + 1;
            for (int i = 0; i < len; ++i) {
                AlphaComposite ac3 = AlphaComposite.getInstance(3, 0.7f);
                g.setComposite(ac3);
                color = new Color(20 + CaptchaRandom.num(110), 20 + CaptchaRandom.num(110), 20 + CaptchaRandom.num(110));
                g.setColor(color);
                g.drawString(strs[i] + "", this.width - (len - i) * w + size, h - 4);
                color = null;
                ac3 = null;
            }
            ImageIO.write((RenderedImage)bi, "png", out);
            out.flush();
            ok = true;
        }
        catch (IOException e) {
            ok = false;
        }
        finally {
            IoUtil.close((Closeable)out);
        }
        return ok;
    }

    public BufferedImage graphicsImage(String strs) {
        Color color;
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        int len = strs.length();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        for (int i = 0; i < 15; ++i) {
            color = this.color(150, 250);
            g.setColor(color);
            g.drawOval(CaptchaRandom.num(this.width), CaptchaRandom.num(this.height), 5 + CaptchaRandom.num(10), 5 + CaptchaRandom.num(10));
            color = null;
        }
        g.setFont(this.font);
        int h = this.height - (this.height - this.font.getSize() >> 1);
        int w = this.width / len;
        int size = w - this.font.getSize() + 1;
        for (int i = 0; i < len; ++i) {
            AlphaComposite ac3 = AlphaComposite.getInstance(3, 0.7f);
            g.setComposite(ac3);
            color = new Color(20 + CaptchaRandom.num(110), 20 + CaptchaRandom.num(110), 20 + CaptchaRandom.num(110));
            g.setColor(color);
            g.drawString(strs.charAt(i) + "", this.width - (len - i) * w + size, h - 4);
            color = null;
            ac3 = null;
        }
        return bi;
    }

    public void out(OutputStream os, String text) {
        this.graphicsImage(text.toCharArray(), os);
    }

    protected char[] alphas() {
        char[] cs = new char[this.len];
        for (int i = 0; i < this.len; ++i) {
            cs[i] = CaptchaRandom.alpha();
        }
        this.chars = new String(cs);
        return cs;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    protected Color color(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + CaptchaRandom.num(bc - fc);
        int g = fc + CaptchaRandom.num(bc - fc);
        int b = fc + CaptchaRandom.num(bc - fc);
        return new Color(r, g, b);
    }

    public String text() {
        return this.chars;
    }
}

