/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.annotation;

import cn.morethank.open.admin.common.annotation.ExcelFormat;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpressionIntegerConverter
implements Converter<Integer> {
    public Class<?> supportJavaTypeKey() {
        return Integer.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public WriteCellData<?> convertToExcelData(Integer value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        ExcelFormat excelFormat = contentProperty.getField().getAnnotation(ExcelFormat.class);
        if (excelFormat != null && value != null) {
            String separator = excelFormat.separator();
            if (StringUtils.isNotEmpty((CharSequence)excelFormat.expression())) {
                String expression = excelFormat.expression();
                String val = this.convertByExp(value, expression, separator);
                return new WriteCellData(val);
            }
        }
        return NumberUtils.formatToCellDataString((Number)value, (ExcelContentProperty)contentProperty);
    }

    private String convertByExp(Integer propertyValue, String converterExp, String separator) {
        String[] convertSource;
        String val = String.valueOf(propertyValue);
        for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (!itemArray[0].equals(val)) continue;
            return itemArray[1];
        }
        return StringUtils.stripEnd((String)val, (String)separator);
    }
}

