/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.annotation;

import cn.morethank.open.admin.common.annotation.ExcelFormat;
import cn.morethank.open.admin.common.util.DictUtils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ExpressionConverter
implements Converter<String> {
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public WriteCellData<?> convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        ExcelFormat excelFormat = contentProperty.getField().getAnnotation(ExcelFormat.class);
        if (excelFormat != null && StringUtils.isNotEmpty((CharSequence)value)) {
            String separator = excelFormat.separator();
            if (StringUtils.isNotEmpty((CharSequence)excelFormat.expression())) {
                String expression = excelFormat.expression();
                String val = this.convertByExp(value, expression, separator);
                return new WriteCellData(val);
            }
            if (StringUtils.isNotEmpty((CharSequence)excelFormat.dict())) {
                String dict = excelFormat.dict();
                String val = this.convertDictByExp(value, dict, separator);
                return new WriteCellData(val);
            }
        }
        return new WriteCellData(value);
    }

    private String convertByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)propertyValue, (CharSequence)separator)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[0].equals(value)) continue;
                    propertyString.append(itemArray[1] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    private String convertDictByExp(String dictValue, String dictType, String separator) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        WebApplicationContext wc = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request);
        DictUtils dictUtils = (DictUtils)wc.getBean(DictUtils.class);
        return dictUtils.getDictLabel(dictType, dictValue, separator);
    }
}

