package cn.morethank.demo.admin;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

/**
 * 演示应用, 没有业务代码。ComponentScan 和 MapperScan 都可以配多个package
 * @author morethank
 * @since 2022/12/17 13:54
 */
@ComponentScan({"cn.morethank.open.admin"})
@MapperScan({"cn.morethank.open.admin.system.mapper"})
@SpringBootApplication
public class DemoAdminApplication {

	public static void main(String[] args) {
		SpringApplication.run(DemoAdminApplication.class, args);
	}
}
