/*
 * Decompiled with CFR 0.152.
 */
package cn.moongoddess.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;

public class FileTools {
    public static boolean downLoadFile(String path, HttpServletResponse response) throws IOException {
        File file = new File(path);
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream fis = new BufferedInputStream(fileInputStream);
        byte[] buffer = new byte[((InputStream)fis).available()];
        ((InputStream)fis).read(buffer);
        ((InputStream)fis).close();
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
        response.addHeader("Content-Length", "" + file.length());
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        response.setContentType("application/octet-stream");
        ((OutputStream)outputStream).write(buffer);
        ((OutputStream)outputStream).flush();
        return true;
    }

    public static void downLoadFile(String path, String realName, HttpServletResponse response) throws IOException {
        File file = new File(path);
        String filename = file.getName();
        String ext = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
        byte[] buffer = new byte[((InputStream)inputStream).available()];
        ((InputStream)inputStream).read(buffer);
        ((InputStream)inputStream).close();
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(realName + "." + ext, "UTF-8"));
        response.addHeader("Content-Length", "" + file.length());
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        response.setContentType("application/octet-stream");
        ((OutputStream)outputStream).write(buffer);
        ((OutputStream)outputStream).flush();
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

