/*
 * Decompiled with CFR 0.152.
 */
package cn.moongoddess.core.metrology;

import cn.moongoddess.core.model.RoundingParams;
import java.math.BigDecimal;

public class RoundingOff {
    public static String get(String value, String level) {
        RoundingParams rp;
        switch (level) {
            case "0.02": {
                rp = new RoundingParams("2", 3);
                break;
            }
            case "0.05": {
                rp = new RoundingParams("5", 3);
                break;
            }
            case "0.2": {
                rp = new RoundingParams("2", 2);
                break;
            }
            case "0.5": {
                rp = new RoundingParams("5", 2);
                break;
            }
            case "1": {
                rp = new RoundingParams("1", 1);
                break;
            }
            case "2": {
                rp = new RoundingParams("2", 1);
                break;
            }
            default: {
                rp = null;
            }
        }
        if (rp == null) {
            return null;
        }
        BigDecimal multiply = new BigDecimal(value).divide(new BigDecimal(rp.getCoefficient())).setScale(rp.getDecimalPlace(), 6).multiply(new BigDecimal(rp.getCoefficient()));
        return RoundingOff.numDecimal(multiply.toString(), rp.getDecimalPlace());
    }

    private static String numDecimal(String num, int len) {
        if (len == 0) {
            return num.split("\\.")[0];
        }
        if (num.indexOf(".") == -1 && len != 0) {
            num = num + ".0";
        }
        String[] split = num.split("\\.");
        String decimal = split[1];
        num = split[0];
        if (decimal.length() > len) {
            decimal = decimal.substring(0, len);
        } else {
            while (decimal.length() != len) {
                decimal = decimal + "0";
            }
        }
        return num + "." + decimal;
    }
}

