/*
 * Decompiled with CFR 0.152.
 */
package cn.moongoddess.core.metrology;

import java.math.BigDecimal;

public class RoundingOff {
    public static String getRoundingCoefficient(String level) {
        String coefficient;
        switch (level) {
            case "0.02": 
            case "0.2": 
            case "2": {
                coefficient = "2";
                break;
            }
            case "0.05": 
            case "0.5": {
                coefficient = "5";
                break;
            }
            case "1": {
                coefficient = "1";
                break;
            }
            default: {
                coefficient = null;
            }
        }
        return coefficient;
    }

    public static int getRoundingDecimalPlace(String level) {
        int decimalPlace;
        switch (level) {
            case "0.02": 
            case "0.05": {
                decimalPlace = 3;
                break;
            }
            case "0.2": 
            case "0.5": {
                decimalPlace = 2;
                break;
            }
            case "1": 
            case "2": {
                decimalPlace = 1;
                break;
            }
            default: {
                decimalPlace = 0;
            }
        }
        return decimalPlace;
    }

    public static String getByValueAndLevel(String value, String level) {
        BigDecimal multiply = new BigDecimal(value).divide(new BigDecimal(RoundingOff.getRoundingCoefficient(level))).setScale(RoundingOff.getRoundingDecimalPlace(level), 6).multiply(new BigDecimal(RoundingOff.getRoundingCoefficient(level)));
        return RoundingOff.numDecimal(multiply.toString(), RoundingOff.getRoundingDecimalPlace(level));
    }

    public static String numDecimal(String num, int len) {
        if (len == 0) {
            return num.split("\\.")[0];
        }
        if (num.indexOf(".") == -1 && len != 0) {
            num = num + ".0";
        }
        String[] split = num.split("\\.");
        String decimal = split[1];
        num = split[0];
        if (decimal.length() > len) {
            decimal = decimal.substring(0, len);
        } else {
            while (decimal.length() != len) {
                decimal = decimal + "0";
            }
        }
        return num + "." + decimal;
    }
}

