/*
 * Decompiled with CFR 0.152.
 */
package cn.montaro.relaxhttp;

import cn.montaro.relaxhttp.interfaces.API;
import cn.montaro.relaxhttp.interfaces.RequestRecord;
import cn.montaro.relaxhttp.interfaces.adapter.RequestAdapter;
import cn.montaro.relaxhttp.interfaces.adapter.ResultAdapter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class RequestResolver
implements InvocationHandler {
    private String baseUrl;
    private String contentType;
    private OkHttpClient okHttpClient;
    private RequestAdapter requestAdapter;
    private ResultAdapter resultAdapter;

    public abstract RequestRecord getRequestRecord(Method var1, Object[] var2);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(API.class)) {
            return this;
        }
        RequestRecord requestRecord = this.getRequestRecord(method, args);
        Request request = this.requestAdapter.onConvert(requestRecord, args).build();
        Response response = this.okHttpClient.newCall(request).execute();
        Object result = this.resultAdapter.onConvert(response, method.getReturnType(), method.getGenericReturnType());
        return result;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public RequestAdapter getRequestAdapter() {
        return this.requestAdapter;
    }

    public void setRequestAdapter(RequestAdapter requestAdapter) {
        this.requestAdapter = requestAdapter;
    }

    public ResultAdapter getResultAdapter() {
        return this.resultAdapter;
    }

    public void setResultAdapter(ResultAdapter resultAdapter) {
        this.resultAdapter = resultAdapter;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

