/*
 * Decompiled with CFR 0.152.
 */
package cn.montaro.relaxhttp;

import cn.montaro.relaxhttp.DefaultRequestResolver;
import cn.montaro.relaxhttp.DefaultResultAdapter;
import cn.montaro.relaxhttp.RequestResolver;
import cn.montaro.relaxhttp.annotation.method.ContentType;
import cn.montaro.relaxhttp.annotation.type.BaseUrl;
import cn.montaro.relaxhttp.interfaces.API;
import cn.montaro.relaxhttp.interfaces.adapter.ResultAdapter;
import cn.montaro.relaxhttp.util.ParamUtils;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RelaxHttp {
    public static final String MEDIA_TYPE_JSON = "application/json; charset=utf-8";
    public static final String MEDIA_TYPE_FORM = "application/x-www-form-urlencoded; charset=utf-8";
    public static ResultAdapter resultAdapter = new DefaultResultAdapter();
    public static OkHttpClient okHttpClient = new OkHttpClient();

    public static final <T extends API> T create(Class<T> api, RequestResolver resolver, OkHttpClient client) {
        if (!api.isInterface()) {
            throw new IllegalArgumentException("argument must be interface class");
        }
        RequestResolver handler = RelaxHttp.createProxyObject(api, resolver, client);
        return (T)((API)Proxy.newProxyInstance(api.getClassLoader(), new Class[]{api}, (InvocationHandler)handler));
    }

    public static final <T extends API> T create(Class<T> api, OkHttpClient client) {
        return RelaxHttp.create(api, new DefaultRequestResolver(), client);
    }

    public static final <T extends API> T create(Class<T> api) {
        return RelaxHttp.create(api, new OkHttpClient());
    }

    private static <T extends API> void handleClass(Class<T> api, RequestResolver requestResolver) {
        ContentType contentType;
        BaseUrl baseUrl = api.getAnnotation(BaseUrl.class);
        if (baseUrl != null) {
            requestResolver.setBaseUrl(baseUrl.value());
        }
        if ((contentType = api.getAnnotation(ContentType.class)) != null) {
            requestResolver.setContentType(contentType.value());
        }
    }

    private static <T extends API> RequestResolver createProxyObject(Class<T> api, RequestResolver requestResolver, OkHttpClient client) {
        RelaxHttp.handleClass(api, requestResolver);
        requestResolver.setOkHttpClient(client);
        return requestResolver;
    }

    public static <T> T get(String url, Map<String, Object> params, Class<T> resultType) throws IOException {
        return RelaxHttp.get(url, params, resultType, resultAdapter);
    }

    public static <T> T get(String url, Map<String, Object> params, Class<T> resultType, ResultAdapter resultAdapter) throws IOException {
        String realUrl = ParamUtils.addParam(url, params);
        Request request = new Request.Builder().url(realUrl).get().build();
        Response response = okHttpClient.newCall(request).execute();
        T result = resultAdapter.onConvert(response, resultType, null);
        return result;
    }

    public static <T> T post(String url, MediaType mediaType, String data, Class<T> resultType) throws IOException {
        return RelaxHttp.post(url, mediaType, data, resultType, resultAdapter);
    }

    public static <T> T post(String url, MediaType mediaType, String data, Class<T> resultType, ResultAdapter resultAdapter) throws IOException {
        Request request = new Request.Builder().url(url).post(RequestBody.create((MediaType)mediaType, (String)data)).build();
        Response response = okHttpClient.newCall(request).execute();
        T result = resultAdapter.onConvert(response, resultType, null);
        return result;
    }
}

