/*
 * Decompiled with CFR 0.152.
 */
package cn.montaro.relaxhttp;

import cn.montaro.relaxhttp.DefaultRequestAdapter;
import cn.montaro.relaxhttp.DefaultRequestRecord;
import cn.montaro.relaxhttp.DefaultResultAdapter;
import cn.montaro.relaxhttp.RequestMethodAndPath;
import cn.montaro.relaxhttp.RequestResolver;
import cn.montaro.relaxhttp.annotation.method.ContentType;
import cn.montaro.relaxhttp.annotation.method.DisableBaseUrl;
import cn.montaro.relaxhttp.annotation.method.request.DELETE;
import cn.montaro.relaxhttp.annotation.method.request.GET;
import cn.montaro.relaxhttp.annotation.method.request.POST;
import cn.montaro.relaxhttp.annotation.method.request.PUT;
import cn.montaro.relaxhttp.annotation.parameter.Body;
import cn.montaro.relaxhttp.annotation.parameter.Header;
import cn.montaro.relaxhttp.annotation.parameter.Path;
import cn.montaro.relaxhttp.annotation.parameter.Query;
import cn.montaro.relaxhttp.annotation.type.BaseUrl;
import cn.montaro.relaxhttp.interfaces.RequestRecord;
import cn.montaro.relaxhttp.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class DefaultRequestResolver
extends RequestResolver {
    private Map<Method, RequestRecord> cachedRequestRecord = new HashMap<Method, RequestRecord>();
    private Boolean enableCache = true;

    public DefaultRequestResolver() {
        this.setOkHttpClient(new OkHttpClient());
        this.setRequestAdapter(new DefaultRequestAdapter());
        this.setResultAdapter(new DefaultResultAdapter());
    }

    @Override
    public RequestRecord getRequestRecord(Method method, Object[] args) {
        String baseUrl;
        if (this.enableCache.booleanValue() && this.cachedRequestRecord.containsKey(method)) {
            return this.cachedRequestRecord.get(method);
        }
        DefaultRequestRecord defaultRequestRecord = new DefaultRequestRecord();
        defaultRequestRecord.baseUrl = baseUrl = this.getMethodBaseUrl(method);
        String contentType = this.getContentType(method);
        defaultRequestRecord.contentType = StringUtils.choose(contentType, this.getContentType(), defaultRequestRecord.contentType);
        RequestMethodAndPath requestMethodAndPath = this.getRequestMethodAndPath(method);
        defaultRequestRecord.setRequestMethodAndPath(requestMethodAndPath);
        this.getRequestParameters(method, defaultRequestRecord);
        if (this.enableCache.booleanValue()) {
            this.cachedRequestRecord.put(method, defaultRequestRecord);
        }
        return defaultRequestRecord;
    }

    private String getMethodBaseUrl(Method method) {
        DisableBaseUrl disableBaseUrl = method.getAnnotation(DisableBaseUrl.class);
        if (disableBaseUrl != null) {
            return "";
        }
        BaseUrl baseUrl = method.getAnnotation(BaseUrl.class);
        if (baseUrl != null) {
            return baseUrl.value();
        }
        return this.getBaseUrl();
    }

    private RequestMethodAndPath getRequestMethodAndPath(Method method) {
        GET get = method.getAnnotation(GET.class);
        POST post = method.getAnnotation(POST.class);
        PUT put = method.getAnnotation(PUT.class);
        DELETE delete = method.getAnnotation(DELETE.class);
        if (delete != null) {
            return new RequestMethodAndPath("DELETE", delete.value());
        }
        if (put != null) {
            return new RequestMethodAndPath("PUT", put.value());
        }
        if (post != null) {
            return new RequestMethodAndPath("POST", post.value());
        }
        return new RequestMethodAndPath("GET", get.value());
    }

    private void getRequestParameters(Method method, DefaultRequestRecord requestRecord) {
        HashMap<String, Integer> pathParameters = new HashMap<String, Integer>();
        HashMap<String, Integer> bodyParameters = new HashMap<String, Integer>();
        HashMap<String, Integer> queryParameters = new HashMap<String, Integer>();
        HashMap<String, Integer> headerParameters = new HashMap<String, Integer>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Path path = parameter.getAnnotation(Path.class);
            Body body = parameter.getAnnotation(Body.class);
            Query query = parameter.getAnnotation(Query.class);
            Header header = parameter.getAnnotation(Header.class);
            String paramName = parameter.getName();
            if (path != null) {
                paramName = StringUtils.choose(path.value(), paramName);
                pathParameters.put(paramName, i);
            }
            if (body != null) {
                paramName = StringUtils.choose(body.value(), paramName);
                bodyParameters.put(paramName, i);
            }
            if (query != null) {
                paramName = StringUtils.choose(query.value(), paramName);
                queryParameters.put(paramName, i);
            }
            if (header == null) continue;
            paramName = StringUtils.choose(header.value(), paramName);
            headerParameters.put(paramName, i);
        }
        requestRecord.bodyParameters = bodyParameters;
        requestRecord.pathParameters = pathParameters;
        requestRecord.queryParameters = queryParameters;
        requestRecord.headerParameters = headerParameters;
    }

    private String getContentType(Method method) {
        ContentType contentType = method.getAnnotation(ContentType.class);
        if (contentType != null) {
            return contentType.value();
        }
        return "";
    }

    public Boolean getEnableCache() {
        return this.enableCache;
    }

    public void setEnableCache(Boolean enableCache) {
        this.enableCache = enableCache;
    }
}

