/*
 * Decompiled with CFR 0.152.
 */
package cn.montaro.relaxhttp;

import cn.montaro.relaxhttp.RequestMethodAndPath;
import cn.montaro.relaxhttp.interfaces.RequestRecord;
import cn.montaro.relaxhttp.util.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultRequestRecord
implements RequestRecord {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    public static final String MEDIA_TYPE_XML = "text/xml";
    public static final String MEDIA_TYPE_JSON = "application/json";
    public static final String MEDIA_TYPE_MULTIPART = "multipart/form-data";
    public static final String MEDIA_TYPE_FORM = "application/x-www-form-urlencoded";
    public String baseUrl;
    public String requestMethod;
    public String requestPath;
    public String contentType = "application/x-www-form-urlencoded";
    public Map<String, Integer> pathParameters = new HashMap<String, Integer>();
    public Map<String, Integer> bodyParameters = new HashMap<String, Integer>();
    public Map<String, Integer> queryParameters = new HashMap<String, Integer>();
    public Map<String, Integer> headerParameters = new HashMap<String, Integer>();

    public void setRequestMethodAndPath(String requestMethod, String requestPath) {
        this.requestPath = requestPath;
        this.requestMethod = requestMethod;
    }

    public void setRequestMethodAndPath(RequestMethodAndPath requestMethodAndPath) {
        this.setRequestMethodAndPath(requestMethodAndPath.requestMethod, requestMethodAndPath.requestPath);
    }

    @Override
    public String getRequestUrl(Object[] args) {
        String requestUrl = this.baseUrl + this.requestPath;
        Set<String> keys = this.pathParameters.keySet();
        for (String key : keys) {
            String pathName = "{" + key + "}";
            if (requestUrl.indexOf(pathName) == -1) continue;
            Integer index = this.pathParameters.get(key);
            String value = args[index].toString();
            requestUrl = requestUrl.replace(pathName, value);
        }
        if (this.requestMethod.equalsIgnoreCase(METHOD_GET)) {
            requestUrl = ParamUtils.addParam(requestUrl, DefaultRequestRecord.getRealParamMap(this.queryParameters, args));
        }
        return requestUrl;
    }

    public static Map<String, Object> getRealParamMap(Map<String, Integer> map, Object[] args) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Integer index = map.get(key);
            Object val = args[index];
            result.put(key, val);
        }
        return result;
    }
}

