/*
 * Decompiled with CFR 0.152.
 */
package cn.montaro.relaxhttp;

import cn.montaro.relaxhttp.DefaultRequestRecord;
import cn.montaro.relaxhttp.interfaces.RequestRecord;
import cn.montaro.relaxhttp.interfaces.adapter.RequestAdapter;
import cn.montaro.relaxhttp.util.ParamUtils;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class DefaultRequestAdapter
implements RequestAdapter {
    @Override
    public Request.Builder onConvert(RequestRecord requestRecord, Object[] args) {
        DefaultRequestRecord defaultRequestRecord = (DefaultRequestRecord)requestRecord;
        Request.Builder builder = new Request.Builder().url(defaultRequestRecord.getRequestUrl(args));
        Map<String, Integer> headerMap = defaultRequestRecord.headerParameters;
        Set<String> headerKeys = headerMap.keySet();
        for (String headerName : headerKeys) {
            Integer index = headerMap.get(headerName);
            String value = args[index].toString();
            builder.header(headerName, value);
        }
        builder = this.onBuildRequestContent(builder, requestRecord, args);
        return builder;
    }

    @Override
    public Request.Builder onBuildRequestContent(Request.Builder builder, RequestRecord requestRecord, Object[] args) {
        DefaultRequestRecord defaultRequestRecord = (DefaultRequestRecord)requestRecord;
        Map<String, Integer> bodyMap = defaultRequestRecord.bodyParameters;
        if (bodyMap.size() != 0) {
            String content = "";
            Map<String, Object> dataMap = this.getParametersMap(bodyMap, args);
            MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
            if (defaultRequestRecord.contentType != "") {
                mediaType = MediaType.parse((String)defaultRequestRecord.contentType);
            }
            if (mediaType.subtype().equalsIgnoreCase("x-www-form-urlencoded")) {
                content = ParamUtils.param2String(dataMap);
            }
            if (mediaType.subtype().equalsIgnoreCase("json")) {
                content = JSON.toJSONString(dataMap);
            }
            if (!defaultRequestRecord.requestMethod.equalsIgnoreCase("GET")) {
                builder.method(defaultRequestRecord.requestMethod, RequestBody.create((MediaType)mediaType, (String)content));
            } else {
                builder.get();
            }
        }
        return builder;
    }

    public Map<String, Object> getParametersMap(Map<String, Integer> parameterOrder, Object[] args) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<String> keySet = parameterOrder.keySet();
        for (String s : keySet) {
            Integer index = parameterOrder.get(s);
            result.put(s, args[index]);
        }
        return result;
    }
}

