package cn.montaro.relaxhttp;


import cn.montaro.relaxhttp.interfaces.adapter.ResultAdapter;
import com.alibaba.fastjson.JSON;
import okhttp3.Response;

import java.io.IOException;
import java.lang.reflect.Type;

public class DefaultResultAdapter implements ResultAdapter {

    @Override
    public <T> T onConvert(Response response, Class<T> returnType, Type genericType) throws IOException {
        String content = response.body().string();
        T result = JSON.parseObject(content, genericType == null ? returnType : genericType);
        return result;
    }
}
