package cn.montaro.relaxhttp;

import cn.montaro.relaxhttp.interfaces.RequestRecord;
import cn.montaro.relaxhttp.interfaces.adapter.RequestAdapter;
import cn.montaro.relaxhttp.util.ParamUtils;
import com.alibaba.fastjson.JSON;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultRequestAdapter implements RequestAdapter {

    @Override
    public Request.Builder onConvert(RequestRecord requestRecord, Object[] args) {
        DefaultRequestRecord defaultRequestRecord = (DefaultRequestRecord) requestRecord;
        Request.Builder builder = new Request.Builder().url(defaultRequestRecord.getRequestUrl(args));
        // 添加请求头
        Map<String, Integer> headerMap = defaultRequestRecord.headerParameters;
        Set<String> headerKeys = headerMap.keySet();
        for (String headerName : headerKeys) {
            Integer index = headerMap.get(headerName);
            String value = args[index].toString();
            builder.header(headerName, value);
        }

        builder = this.onBuildRequestContent(builder, requestRecord, args);

        return builder;
    }

    @Override
    public Request.Builder onBuildRequestContent(Request.Builder builder, RequestRecord requestRecord, Object[] args) {
        DefaultRequestRecord defaultRequestRecord = (DefaultRequestRecord) requestRecord;
        Map<String, Integer> bodyMap = defaultRequestRecord.bodyParameters;
        if (bodyMap.size() != 0) {
            // 根据mediaType构造请求数据
            String content = "";
            Map<String, Object> dataMap = getParametersMap(bodyMap, args);
            MediaType mediaType = MediaType.parse(RelaxHttp.MEDIA_TYPE_FORM);
            if (defaultRequestRecord.contentType != "") {
                mediaType = MediaType.parse(defaultRequestRecord.contentType);
            }
            if (mediaType.subtype().equalsIgnoreCase("x-www-form-urlencoded")) {
                content = ParamUtils.param2String(dataMap);
            }
            if (mediaType.subtype().equalsIgnoreCase("json")) {
                content = JSON.toJSONString(dataMap);
            }
            if (!defaultRequestRecord.requestMethod.equalsIgnoreCase(DefaultRequestRecord.METHOD_GET))
                builder.method(defaultRequestRecord.requestMethod, RequestBody.create(mediaType, content));
            else
                builder.get();
        }
        return builder;
    }


    public Map<String, Object> getParametersMap(Map<String, Integer> parameterOrder, Object[] args) {
        Map<String, Object> result = new HashMap<>();
        Set<String> keySet = parameterOrder.keySet();
        for (String s : keySet) {
            Integer index = parameterOrder.get(s);
            result.put(s, args[index]);
        }
        return result;
    }

}
