/*
 * Decompiled with CFR 0.152.
 */
package cn.moltres.component_bus;

import cn.moltres.component_bus.Chain;
import cn.moltres.component_bus.ComponentBus;
import cn.moltres.component_bus.IComponent;
import cn.moltres.component_bus.Result;
import cn.moltres.component_bus.interceptor.ComponentInterceptor;
import cn.moltres.component_bus.interceptor.IInterceptor;
import cn.moltres.component_bus.interceptor.NotFindComponentInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0002J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0004\b\u0000\u0010\u001aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0004\b\u0000\u0010\u001aJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcn/moltres/component_bus/Request;", "", "componentName", "", "action", "(Ljava/lang/String;Ljava/lang/String;)V", "getAction", "()Ljava/lang/String;", "setAction", "(Ljava/lang/String;)V", "getComponentName", "setComponentName", "interceptors", "", "getInterceptors", "()Ljava/util/List;", "params", "", "getParams", "()Ljava/util/Map;", "addInterceptor", "", "interceptorArray", "Lcn/moltres/component_bus/interceptor/IInterceptor;", "call", "Lcn/moltres/component_bus/Result;", "T", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "callSync", "initInterceptor", "interceptor", "key", "value", "component_bus_core"})
@SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\ncn/moltres/component_bus/Request\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n37#2,2:52\n37#2,2:54\n1#3:56\n*S KotlinDebug\n*F\n+ 1 Request.kt\ncn/moltres/component_bus/Request\n*L\n26#1:52,2\n27#1:54,2\n*E\n"})
public final class Request {
    @NotNull
    private String componentName;
    @NotNull
    private String action;
    @NotNull
    private final Map<String, Object> params;
    @NotNull
    private final List<String> interceptors;

    public Request(@NotNull String componentName, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.componentName = componentName;
        this.action = action;
        this.params = new LinkedHashMap();
        this.interceptors = new ArrayList();
    }

    @NotNull
    public final String getComponentName() {
        return this.componentName;
    }

    public final void setComponentName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.componentName = string;
    }

    @NotNull
    public final String getAction() {
        return this.action;
    }

    public final void setAction(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.action = string;
    }

    @NotNull
    public final Map<String, Object> getParams() {
        return this.params;
    }

    @NotNull
    public final List<String> getInterceptors() {
        return this.interceptors;
    }

    @NotNull
    public final Request params(@NotNull String key, @NotNull Object value) {
        Request request;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Request $this$params_u24lambda_u240 = request = this;
        boolean bl = false;
        $this$params_u24lambda_u240.params.put(key, value);
        return request;
    }

    @NotNull
    public final Request interceptors(@NotNull String interceptor) {
        Request request;
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        Request $this$interceptors_u24lambda_u241 = request = this;
        boolean bl = false;
        $this$interceptors_u24lambda_u241.interceptors.add(interceptor);
        return request;
    }

    @Nullable
    public final <T> Object call(@NotNull Continuation<? super Result<T>> $completion) {
        Collection $this$toTypedArray$iv = this.initInterceptor();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IInterceptor[] iInterceptorArray = thisCollection$iv.toArray(new IInterceptor[0]);
        return new Chain(this, Arrays.copyOf(iInterceptorArray, iInterceptorArray.length)).proceed($completion);
    }

    @NotNull
    public final <T> Result<T> callSync() {
        Collection $this$toTypedArray$iv = this.initInterceptor();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IInterceptor[] iInterceptorArray = thisCollection$iv.toArray(new IInterceptor[0]);
        return new Chain(this, Arrays.copyOf(iInterceptorArray, iInterceptorArray.length)).proceedSync();
    }

    private final List<IInterceptor> initInterceptor() {
        List list;
        List $this$initInterceptor_u24lambda_u243 = list = (List)new ArrayList();
        boolean bl = false;
        $this$initInterceptor_u24lambda_u243.addAll((Collection)ComponentBus.INSTANCE.getGlobalInterceptorArray$component_bus_core());
        IComponent component = ComponentBus.INSTANCE.getComponent$component_bus_core(this.componentName);
        if (component == null) {
            this.addInterceptor($this$initInterceptor_u24lambda_u243);
            $this$initInterceptor_u24lambda_u243.add($this$initInterceptor_u24lambda_u243.size(), new NotFindComponentInterceptor());
        } else {
            Object[] objectArray = component.getInterceptorNames(this.action);
            if (objectArray != null) {
                Object[] it = objectArray;
                boolean bl2 = false;
                CollectionsKt.addAll((Collection)this.interceptors, (Object[])it);
            }
            this.addInterceptor($this$initInterceptor_u24lambda_u243);
            $this$initInterceptor_u24lambda_u243.add($this$initInterceptor_u24lambda_u243.size(), new ComponentInterceptor(component));
        }
        return list;
    }

    private final void addInterceptor(List<IInterceptor> interceptorArray) {
        if (!((Collection)this.interceptors).isEmpty()) {
            for (String name : this.interceptors) {
                if (ComponentBus.INSTANCE.getInterceptor$component_bus_core(name) != null) {
                    IInterceptor it;
                    boolean bl = false;
                    interceptorArray.add(interceptorArray.size(), it);
                }
            }
        }
    }
}

