/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.wechat.wechatpay.core;

import cn.minsin.core.init.WechatPayCoreConfig;
import cn.minsin.core.thirdpart.HttpClientFactory;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.mutils.wechat.wechatpay.core.model.BaseWeChatPayModel;
import org.mutils.wechat.wechatpay.core.util.ParseXmlUtil;
import org.mutils.wechat.wechatpay.core.util.SignUtil;

public class WeChatPayFunctions {
    public static Map<String, String> createJSAPIPayParamter(Map<String, String> doXMLParse) {
        WeChatPayFunctions.checkMap(doXMLParse);
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        try {
            String appId = doXMLParse.get("appid");
            sortMap.put("appId", appId);
            sortMap.put("nonceStr", doXMLParse.get("nonce_str"));
            sortMap.put("package", "prepay_id=" + doXMLParse.get("prepay_id"));
            sortMap.put("signType", "MD5");
            sortMap.put("timeStamp", System.currentTimeMillis() / 1000L + "");
            String sign = SignUtil.createSign(sortMap, WechatPayCoreConfig.wechatPayConfig.getPartnerKey());
            sortMap.put("paySign", sign);
            sortMap.put("prepay_id", doXMLParse.get("prepay_id"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortMap;
    }

    public static Map<String, String> createMiniProgramPayParamter(Map<String, String> doXMLParse) {
        WeChatPayFunctions.checkMap(doXMLParse);
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        try {
            String appId = doXMLParse.get("appid");
            String nonceStr = doXMLParse.get("nonce_str");
            String package_str = "prepay_id=" + doXMLParse.get("prepay_id");
            String signType = "MD5";
            String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
            sortMap.put("appId", appId);
            sortMap.put("nonceStr", nonceStr);
            sortMap.put("package", package_str);
            sortMap.put("signType", signType);
            sortMap.put("timeStamp", timeStamp);
            String sign = SignUtil.createSign(sortMap, WechatPayCoreConfig.wechatPayConfig.getPartnerKey());
            sortMap.put("paySign", sign);
            sortMap.remove("appId");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortMap;
    }

    public static Map<String, String> createAppPayParamter(Map<String, String> doXMLParse) {
        WeChatPayFunctions.checkMap(doXMLParse);
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        try {
            String appId = doXMLParse.get("appid");
            String nonceStr = doXMLParse.get("nonce_str");
            String prepayid = doXMLParse.get("prepay_id");
            String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
            sortMap.put("appid", appId);
            sortMap.put("partnerid", WechatPayCoreConfig.wechatPayConfig.getPartnerId());
            sortMap.put("noncestr", nonceStr);
            sortMap.put("package", "Sign=WXPay");
            sortMap.put("timestamp", timeStamp);
            sortMap.put("prepayid", prepayid);
            String sign = SignUtil.createSign(sortMap, WechatPayCoreConfig.wechatPayConfig.getPartnerKey());
            sortMap.put("sign", sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortMap;
    }

    public static Map<String, Object> createInitJSConfig(String url) {
        return null;
    }

    public static String createRefundXml(String transaction_id, String out_refund_no, int total_fee, int refund_fee) {
        return null;
    }

    public static String createWithdrawXml(String out_refund_no, BigDecimal amount, String openId, String re_user_name) {
        return null;
    }

    public static Map<String, String> getRefundMap(String url, String xmlParam) {
        System.out.println("xml\u662f:" + xmlParam);
        try {
            CloseableHttpClient httpclient = HttpClientFactory.getSSLInstance((boolean)true, (String)WechatPayCoreConfig.wechatPayConfig.getPartnerId(), (String)WechatPayCoreConfig.wechatPayConfig.getCertificatePath(), (String)WechatPayCoreConfig.wechatPayConfig.getCertificateFormat());
            HttpPost httpost = HttpClientFactory.getPostMethod((String)WechatPayCoreConfig.wechatPayConfig.getRefundUrl());
            httpost.setEntity((HttpEntity)new StringEntity(xmlParam, "UTF-8"));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpost);
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            System.out.println("json\u662f:" + jsonStr);
            httpclient.close();
            return ParseXmlUtil.doXMLParse(jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, String> unifiedOrder(BaseWeChatPayModel model) {
        String xmlParam = model.toXml(WechatPayCoreConfig.wechatPayConfig.getPartnerKey());
        System.out.println("xml\u662f:" + xmlParam);
        CloseableHttpClient httpclient = HttpClientFactory.getInstance();
        HttpPost httpost = HttpClientFactory.getPostMethod((String)WechatPayCoreConfig.wechatPayConfig.getUnifiedOrderUrl());
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        try {
            httpost.setEntity((HttpEntity)new StringEntity(xmlParam, "UTF-8"));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpost);
            String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            System.out.println("json\u662f:" + jsonStr);
            if (jsonStr.indexOf("FAIL") != -1) {
                return null;
            }
            httpclient.close();
            return ParseXmlUtil.doXMLParse(jsonStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return sortMap;
        }
    }

    static boolean checkMap(Map<String, String> doXMLParse) {
        if (doXMLParse == null || doXMLParse.isEmpty()) {
            throw new RuntimeException("\u7edf\u4e00\u652f\u4ed8XML\u751f\u6210\u5931\u8d25,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u4e00\u6b65\u64cd\u4f5c. The value from unifiedOrder method is null,please check the parameters.");
        }
        return true;
    }
}

