package org.mutils.wechat.wechatpay.core.model;

import java.lang.reflect.Field;
import java.util.SortedMap;

import org.mutils.wechat.wechatpay.core.util.SignUtil;

import cn.minsin.core.annotation.NotNull;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.WechatPayCoreConfig;
import cn.minsin.core.init.core.AbstractConfig;
import cn.minsin.core.rule.AbstractModelRule;
import cn.minsin.core.tools.ModelUtil;
import cn.minsin.core.tools.StringUtil;


public abstract class BaseWeChatPayModel extends AbstractModelRule {

	protected final static WechatPayCoreConfig config = AbstractConfig.loadConfig(WechatPayCoreConfig.class);
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -6916140873435262221L;

	@NotNull(value="签名  自动生成无须填写",notNull=false)
	private String sign; 
	
	public String getSign() {
		return sign;
	}

	protected void setSign(String sign) {
		this.sign = sign;
	}

	/**
	 * 生成xml
	 * @return
	 * @throws MutilsErrorException 
	 */
	public String toXml(String partnerKey) throws MutilsErrorException {
		SortedMap<String, String> treeMap = ModelUtil.toTreeMap(this);
		String sign = SignUtil.createSign(treeMap, partnerKey);
		this.setSign(sign);
		StringBuffer sb = new StringBuffer("<xml>");
		for (Field field : ModelUtil.getAllFields(this)) {
			try {
				if(ModelUtil.verificationField(field)) continue;
				field.setAccessible(true);
				Object object = field.get(this);
				if (!StringUtil.isBlank(object)) {
					sb.append("<").append(field.getName()).append(">");
					sb.append(object).append("</").append(field.getName()).append(">");
				}
			} catch (Exception e) {
				continue;
			}
		}
		return sb.append("</xml>").toString();
	}
}
