/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.wechat.miniprogram.function;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.IOUtil;
import cn.minsin.core.tools.ModelUtil;
import cn.minsin.wechat.miniprogram.config.MutilsWechatMiniProgramProperties;
import cn.minsin.wechat.miniprogram.model.Code2SessionReturnModel;
import cn.minsin.wechat.miniprogram.model.MiniProgramCodeModel;
import cn.minsin.wechat.miniprogram.model.MiniProgramOrderPayModel;
import cn.minsin.wechat.miniprogram.model.MiniProgramRefundModel;
import cn.minsin.wechat.miniprogram.model.UserInfoModel;
import cn.minsin.wechat.wechatpay.core.config.WechatPayCoreProperties;
import cn.minsin.wechat.wechatpay.core.function.WeChatPayFunctions;
import cn.minsin.wechat.wechatpay.core.model.AccessTokenModel;
import cn.minsin.wechat.wechatpay.core.model.PayModel;
import cn.minsin.wechat.wechatpay.core.model.RefundModel;
import cn.minsin.wechat.wechatpay.core.model.RefundReturnModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatMiniProgramFunctions
extends WeChatPayFunctions {
    private static final Logger log = LoggerFactory.getLogger(WechatMiniProgramFunctions.class);
    @Autowired
    private MutilsWechatMiniProgramProperties properties;
    @Autowired(required=false)
    private WechatPayCoreProperties coreProperties;

    @PostConstruct
    private void init() {
        if (this.coreProperties == null) {
            log.info("\u5fae\u4fe1\u652f\u4ed8\u76f8\u5173\u529f\u80fd\u65e0\u6cd5\u4f7f\u7528,\u5982\u9700\u4f7f\u7528\u8bf7\u5728properties\u4e2d\u914d\u7f6eWeChat\u914d\u7f6emutils.wechat.pay\u76f8\u5173\u5c5e\u6027");
        }
        super.setProperties(this.coreProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Code2SessionReturnModel jscode2session(String code) throws ClientProtocolException, IOException {
        Code2SessionReturnModel code2SessionReturnModel;
        CloseableHttpClient build = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String url = "https://api.weixin.qq.com/sns/jscode2session?appid=APPID&secret=SECRET&js_code=JSCODE&grant_type=authorization_code";
            url = url.replace("APPID", this.properties.getAppid()).replace("SECRET", this.properties.getAppSecret()).replace("JSCODE", code);
            HttpGet get = HttpClientUtil.getGetMethod((String)url);
            response = build.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            code2SessionReturnModel = (Code2SessionReturnModel)((Object)JSON.parseObject((String)string, Code2SessionReturnModel.class));
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{build, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{build, response});
        return code2SessionReturnModel;
    }

    public UserInfoModel getUserInfo(String encryptedData, String code, String iv) throws ClientProtocolException, IOException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException {
        Code2SessionReturnModel jscode2session = this.jscode2session(code);
        byte[] dataByte = Base64.decode((String)encryptedData);
        byte[] keyByte = Base64.decode((String)jscode2session.getSession_key());
        byte[] ivByte = Base64.decode((String)iv);
        int base = 16;
        if (keyByte.length % base != 0) {
            int groups = keyByte.length / base + 1;
            byte[] temp = new byte[groups * base];
            Arrays.fill((byte[])temp, (byte)0);
            System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
            keyByte = temp;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
        parameters.init(new IvParameterSpec(ivByte));
        cipher.init(2, (Key)spec, parameters);
        byte[] resultByte = cipher.doFinal(dataByte);
        String result = new String(resultByte, StandardCharsets.UTF_8);
        return (UserInfoModel)((Object)JSONObject.parseObject((String)result, UserInfoModel.class));
    }

    public Map<String, String> createMiniProgramPayParamter(MiniProgramOrderPayModel model) throws ParseException, IOException, MutilsErrorException {
        model.setAppid(this.properties.getAppid());
        Map doXMLParse = super.createUnifiedOrder((PayModel)model);
        this.checkMap(doXMLParse);
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        String appId = (String)doXMLParse.get("appid");
        String nonceStr = (String)doXMLParse.get("nonce_str");
        String package_str = "prepay_id=" + (String)doXMLParse.get("prepay_id");
        String signType = "MD5";
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        sortMap.put("appId", appId);
        sortMap.put("nonceStr", nonceStr);
        sortMap.put("package", package_str);
        sortMap.put("signType", signType);
        sortMap.put("timeStamp", timeStamp);
        sortMap.put("paySign", super.createSign(sortMap));
        sortMap.remove("appId");
        return sortMap;
    }

    public RefundReturnModel createMiniProgramRefundParamter(MiniProgramRefundModel model) throws ClientProtocolException, IOException, MutilsErrorException {
        model.setAppid(this.properties.getAppid());
        return super.createRefundRequest((RefundModel)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenModel getAccessToken() throws ClientProtocolException, IOException {
        AccessTokenModel accessTokenModel;
        CloseableHttpClient instance = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
            String requestUrl = accessTokenUrl.replace("APPID", this.properties.getAppid()).replace("APPSECRET", this.properties.getAppSecret());
            HttpGet getMethod = HttpClientUtil.getGetMethod((String)requestUrl);
            response = instance.execute((HttpUriRequest)getMethod);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            accessTokenModel = (AccessTokenModel)JSON.parseObject((String)string, AccessTokenModel.class);
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{instance, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{instance, response});
        return accessTokenModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getMiniProgramQrCode(MiniProgramCodeModel model) throws ClientProtocolException, IOException, MutilsErrorException {
        ByteArrayInputStream byteArrayInputStream;
        ModelUtil.verificationField((Object)((Object)model));
        CloseableHttpClient httpClient = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + model.getAccess_token());
            httpPost.addHeader("Content-Type", "application/json");
            StringEntity entity = new StringEntity(model.toString());
            entity.setContentType("image/png");
            entity.setContentEncoding((Header)new BasicHeader("Content-Type", "UTF-8"));
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            InputStream content = response.getEntity().getContent();
            byte[] copyInputStream = IOUtil.copyInputStream((InputStream)content);
            byteArrayInputStream = new ByteArrayInputStream(copyInputStream);
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{httpClient, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{httpClient, response});
        return byteArrayInputStream;
    }
}

