/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.wechat.miniprogram;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.WechatMiniProgramConfig;
import cn.minsin.core.init.core.AbstractConfig;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.IOUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.mutils.wechat.miniprogram.model.AccessTokenModel;
import org.mutils.wechat.miniprogram.model.Code2SessionReturnModel;
import org.mutils.wechat.miniprogram.model.MiniProgramCodeModel;
import org.mutils.wechat.miniprogram.model.MiniProgramOrderPayModel;
import org.mutils.wechat.miniprogram.model.MiniProgramRefundModel;
import org.mutils.wechat.miniprogram.model.UserInfoModel;
import org.mutils.wechat.wechatpay.core.WeChatPayFunctions;
import org.mutils.wechat.wechatpay.core.model.BaseWeChatPayModel;
import org.mutils.wechat.wechatpay.core.model.RefundModel;
import org.mutils.wechat.wechatpay.core.model.RefundReturnModel;

public class WechatMiniProgramFunctions
extends WeChatPayFunctions {
    private static final WechatMiniProgramConfig config = (WechatMiniProgramConfig)AbstractConfig.loadConfig(WechatMiniProgramConfig.class);

    public static Code2SessionReturnModel jscode2session(String code) throws MutilsErrorException {
        Code2SessionReturnModel code2SessionReturnModel;
        CloseableHttpClient build = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String url = "https://api.weixin.qq.com/sns/jscode2session?appid=APPID&secret=SECRET&js_code=JSCODE&grant_type=authorization_code";
            url = url.replace("APPID", config.getAppid()).replace("SECRET", config.getAppSecret()).replace("JSCODE", code);
            HttpGet get = HttpClientUtil.getGetMethod((String)url);
            response = build.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            log.info("Code2SessionReturnModel string is {}", (Object)string);
            code2SessionReturnModel = (Code2SessionReturnModel)((Object)JSON.parseObject((String)string, Code2SessionReturnModel.class));
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException((Throwable)e, "\u5c0f\u7a0b\u5e8f\u4f7f\u7528code\u6362\u53d6openid\u7b49\u4fe1\u606f\u5931\u8d25");
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{build, response});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{build, response});
        return code2SessionReturnModel;
    }

    public static UserInfoModel getUserInfo(String encryptedData, String code, String iv) throws MutilsErrorException {
        try {
            Code2SessionReturnModel jscode2session = WechatMiniProgramFunctions.jscode2session(code);
            byte[] dataByte = Base64.decode((String)encryptedData);
            byte[] keyByte = Base64.decode((String)jscode2session.getSession_key());
            byte[] ivByte = Base64.decode((String)iv);
            int base = 16;
            if (keyByte.length % base != 0) {
                int groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
                byte[] temp = new byte[groups * base];
                Arrays.fill((byte[])temp, (byte)0);
                System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
                keyByte = temp;
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
            parameters.init(new IvParameterSpec(ivByte));
            cipher.init(2, (Key)spec, parameters);
            byte[] resultByte = cipher.doFinal(dataByte);
            String result = new String(resultByte, "UTF-8");
            return (UserInfoModel)((Object)JSONObject.parseObject((String)result, UserInfoModel.class));
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u89e3\u6790\u5c0f\u7a0b\u5e8f\u5bc6\u6587\u5931\u8d25");
        }
    }

    public static Map<String, String> createMiniProgramPayParamter(MiniProgramOrderPayModel model) throws MutilsErrorException {
        try {
            Map doXMLParse = WechatMiniProgramFunctions.createUnifiedOrder((BaseWeChatPayModel)model);
            WechatMiniProgramFunctions.checkMap((Map)doXMLParse);
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            String appId = (String)doXMLParse.get("appid");
            String nonceStr = (String)doXMLParse.get("nonce_str");
            String package_str = "prepay_id=" + (String)doXMLParse.get("prepay_id");
            String signType = "MD5";
            String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
            sortMap.put("appId", appId);
            sortMap.put("nonceStr", nonceStr);
            sortMap.put("package", package_str);
            sortMap.put("signType", signType);
            sortMap.put("timeStamp", timeStamp);
            sortMap.put("paySign", WechatMiniProgramFunctions.createSign(sortMap));
            sortMap.remove("appId");
            return sortMap;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u53d1\u8d77\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u5931\u8d25");
        }
    }

    public static RefundReturnModel createMiniProgramRefundParamter(MiniProgramRefundModel model) throws MutilsErrorException {
        return WechatMiniProgramFunctions.createRefundRequest((RefundModel)model);
    }

    public static AccessTokenModel getAccessToken() throws MutilsErrorException {
        AccessTokenModel accessTokenModel;
        CloseableHttpClient instance = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
            String requestUrl = accessTokenUrl.replace("APPID", config.getAppid()).replace("APPSECRET", config.getAppSecret());
            HttpGet getMethod = HttpClientUtil.getGetMethod((String)requestUrl);
            response = instance.execute((HttpUriRequest)getMethod);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            accessTokenModel = (AccessTokenModel)((Object)JSON.parseObject((String)string, AccessTokenModel.class));
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException((Throwable)e, "\u5c0f\u7a0b\u5e8f\u83b7\u53d6AccessToken\u5931\u8d25");
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{instance, response});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{instance, response});
        return accessTokenModel;
    }

    public static InputStream getMiniProgramQrCode(MiniProgramCodeModel model) throws MutilsErrorException {
        InputStream inputStream;
        model.verificationField();
        CloseableHttpClient httpClient = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + model.getAccess_token());
            httpPost.addHeader("Content-Type", "application/json");
            StringEntity entity = new StringEntity(model.toString());
            entity.setContentType("image/png");
            entity.setContentEncoding((Header)new BasicHeader("Content-Type", "UTF-8"));
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            inputStream = response.getEntity().getContent();
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException((Throwable)e, "\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7801\u4e8c\u7ef4\u7801\u5931\u8d25");
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{httpClient, response});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{httpClient, response});
        return inputStream;
    }
}

