/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.wechat.miniprogram;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.WechatMiniProgramConfig;
import cn.minsin.core.init.core.InitConfig;
import cn.minsin.core.tools.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.mutils.wechat.miniprogram.model.Code2SessionReturnModel;
import org.mutils.wechat.miniprogram.model.MiniProgramOrderPayModel;
import org.mutils.wechat.miniprogram.model.MiniProgramRefundModel;
import org.mutils.wechat.miniprogram.model.UserInfoModel;
import org.mutils.wechat.wechatpay.core.WeChatPayFunctions;
import org.mutils.wechat.wechatpay.core.model.BaseWeChatPayModel;
import org.mutils.wechat.wechatpay.core.model.RefundModel;
import org.mutils.wechat.wechatpay.core.model.RefundReturnModel;

public class WechatMiniProgramFunctions
extends WeChatPayFunctions {
    private static final WechatMiniProgramConfig config = (WechatMiniProgramConfig)InitConfig.loadConfig(WechatMiniProgramConfig.class);

    public static Code2SessionReturnModel jscode2session(String code) throws MutilsErrorException {
        try {
            String url = "https://api.weixin.qq.com/sns/jscode2session?appid=APPID&secret=SECRET&js_code=JSCODE&grant_type=authorization_code";
            url = url.replace("APPID", config.getAppid()).replace("SECRET", config.getAppSecret()).replace("JSCODE", code);
            HttpGet get = HttpClientUtil.getGetMethod((String)url);
            CloseableHttpClient build = HttpClientBuilder.create().build();
            CloseableHttpResponse response = build.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            response.close();
            build.close();
            log.info("Code2SessionReturnModel string is {}", (Object)string);
            return (Code2SessionReturnModel)((Object)JSON.parseObject((String)string, Code2SessionReturnModel.class));
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u5c0f\u7a0b\u5e8f\u4f7f\u7528code\u6362\u53d6openid\u7b49\u4fe1\u606f\u5931\u8d25");
        }
    }

    public static UserInfoModel getUserInfo(String encryptedData, String code, String iv) throws MutilsErrorException {
        try {
            Code2SessionReturnModel jscode2session = WechatMiniProgramFunctions.jscode2session(code);
            byte[] dataByte = Base64.decode((String)encryptedData);
            byte[] keyByte = Base64.decode((String)jscode2session.getSession_key());
            byte[] ivByte = Base64.decode((String)iv);
            int base = 16;
            if (keyByte.length % base != 0) {
                int groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
                byte[] temp = new byte[groups * base];
                Arrays.fill((byte[])temp, (byte)0);
                System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
                keyByte = temp;
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
            parameters.init(new IvParameterSpec(ivByte));
            cipher.init(2, (Key)spec, parameters);
            byte[] resultByte = cipher.doFinal(dataByte);
            String result = new String(resultByte, "UTF-8");
            return (UserInfoModel)((Object)JSONObject.parseObject((String)result, UserInfoModel.class));
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u89e3\u6790\u5c0f\u7a0b\u5e8f\u5bc6\u6587\u5931\u8d25");
        }
    }

    public static Map<String, String> createMiniProgramPayParamter(MiniProgramOrderPayModel model) throws MutilsErrorException {
        try {
            Map doXMLParse = WechatMiniProgramFunctions.createUnifiedOrder((BaseWeChatPayModel)model);
            WechatMiniProgramFunctions.checkMap((Map)doXMLParse);
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            String appId = (String)doXMLParse.get("appid");
            String nonceStr = (String)doXMLParse.get("nonce_str");
            String package_str = "prepay_id=" + (String)doXMLParse.get("prepay_id");
            String signType = "MD5";
            String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
            sortMap.put("appId", appId);
            sortMap.put("nonceStr", nonceStr);
            sortMap.put("package", package_str);
            sortMap.put("signType", signType);
            sortMap.put("timeStamp", timeStamp);
            sortMap.put("paySign", WechatMiniProgramFunctions.createSign(sortMap));
            sortMap.remove("appId");
            return sortMap;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u53d1\u8d77\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u5931\u8d25");
        }
    }

    public static RefundReturnModel createMiniProgramRefundParamter(MiniProgramRefundModel model) throws MutilsErrorException {
        return WechatMiniProgramFunctions.createRefundRequest((RefundModel)model);
    }
}

