/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.wechat.miniprogram;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.AbstractConfig;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.IOUtil;
import cn.minsin.core.tools.ModelUtil;
import cn.minsin.wechat.miniprogram.config.MutilsWechatMiniProgramProperties;
import cn.minsin.wechat.miniprogram.model.Code2SessionReturnModel;
import cn.minsin.wechat.miniprogram.model.MiniProgramCodeModel;
import cn.minsin.wechat.miniprogram.model.MiniProgramOrderPayModel;
import cn.minsin.wechat.miniprogram.model.MiniProgramRefundModel;
import cn.minsin.wechat.miniprogram.model.UserInfoModel;
import cn.minsin.wechat.wechatpay.core.WeChatPayFunctions;
import cn.minsin.wechat.wechatpay.core.config.WechatPayCoreProperties;
import cn.minsin.wechat.wechatpay.core.model.AccessTokenModel;
import cn.minsin.wechat.wechatpay.core.model.BaseWeChatPayModel;
import cn.minsin.wechat.wechatpay.core.model.RefundModel;
import cn.minsin.wechat.wechatpay.core.model.RefundReturnModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.jdom.JDOMException;

public class WechatMiniProgramFunctions
extends WeChatPayFunctions {
    private static final MutilsWechatMiniProgramProperties properties = (MutilsWechatMiniProgramProperties)AbstractConfig.loadConfig(MutilsWechatMiniProgramProperties.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Code2SessionReturnModel jscode2session(String code) throws ClientProtocolException, IOException {
        Code2SessionReturnModel code2SessionReturnModel;
        CloseableHttpClient build = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String url = "https://api.weixin.qq.com/sns/jscode2session?appid=APPID&secret=SECRET&js_code=JSCODE&grant_type=authorization_code";
            url = url.replace("APPID", properties.getAppid()).replace("SECRET", properties.getAppSecret()).replace("JSCODE", code);
            HttpGet get = HttpClientUtil.getGetMethod((String)url);
            response = build.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity);
            LOGGER.info("Code2SessionReturnModel string is {}", (Object)string);
            code2SessionReturnModel = (Code2SessionReturnModel)((Object)JSON.parseObject((String)string, Code2SessionReturnModel.class));
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{build, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{build, response});
        return code2SessionReturnModel;
    }

    public static UserInfoModel getUserInfo(String encryptedData, String code, String iv) throws ClientProtocolException, IOException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException {
        Code2SessionReturnModel jscode2session = WechatMiniProgramFunctions.jscode2session(code);
        byte[] dataByte = Base64.decode((String)encryptedData);
        byte[] keyByte = Base64.decode((String)jscode2session.getSession_key());
        byte[] ivByte = Base64.decode((String)iv);
        int base = 16;
        if (keyByte.length % base != 0) {
            int groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill((byte[])temp, (byte)0);
            System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
            keyByte = temp;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
        parameters.init(new IvParameterSpec(ivByte));
        cipher.init(2, (Key)spec, parameters);
        byte[] resultByte = cipher.doFinal(dataByte);
        String result = new String(resultByte, "UTF-8");
        return (UserInfoModel)((Object)JSONObject.parseObject((String)result, UserInfoModel.class));
    }

    public static Map<String, String> createMiniProgramPayParamter(MiniProgramOrderPayModel model) throws ParseException, IOException, MutilsErrorException, JDOMException {
        Map doXMLParse = WechatMiniProgramFunctions.createUnifiedOrder((BaseWeChatPayModel)model);
        WechatMiniProgramFunctions.checkMap((Map)doXMLParse);
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        String appId = (String)doXMLParse.get("appid");
        String nonceStr = (String)doXMLParse.get("nonce_str");
        String package_str = "prepay_id=" + (String)doXMLParse.get("prepay_id");
        String signType = "MD5";
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        sortMap.put("appId", appId);
        sortMap.put("nonceStr", nonceStr);
        sortMap.put("package", package_str);
        sortMap.put("signType", signType);
        sortMap.put("timeStamp", timeStamp);
        sortMap.put("paySign", WechatMiniProgramFunctions.createSign(sortMap));
        sortMap.remove("appId");
        return sortMap;
    }

    public static RefundReturnModel createMiniProgramRefundParamter(MiniProgramRefundModel model) throws ClientProtocolException, JDOMException, IOException, MutilsErrorException {
        return WechatMiniProgramFunctions.createRefundRequest((RefundModel)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessTokenModel getAccessToken() throws ClientProtocolException, IOException {
        AccessTokenModel accessTokenModel;
        CloseableHttpClient instance = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
            String requestUrl = accessTokenUrl.replace("APPID", properties.getAppid()).replace("APPSECRET", properties.getAppSecret());
            HttpGet getMethod = HttpClientUtil.getGetMethod((String)requestUrl);
            response = instance.execute((HttpUriRequest)getMethod);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            accessTokenModel = (AccessTokenModel)JSON.parseObject((String)string, AccessTokenModel.class);
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{instance, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{instance, response});
        return accessTokenModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getMiniProgramQrCode(MiniProgramCodeModel model) throws ClientProtocolException, IOException, MutilsErrorException {
        ByteArrayInputStream byteArrayInputStream;
        ModelUtil.verificationField((Object)((Object)model));
        CloseableHttpClient httpClient = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + model.getAccess_token());
            httpPost.addHeader("Content-Type", "application/json");
            StringEntity entity = new StringEntity(model.toString());
            entity.setContentType("image/png");
            entity.setContentEncoding((Header)new BasicHeader("Content-Type", "UTF-8"));
            httpPost.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            InputStream content = response.getEntity().getContent();
            byte[] copyInputStream = IOUtil.copyInputStream((InputStream)content);
            byteArrayInputStream = new ByteArrayInputStream(copyInputStream);
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{httpClient, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{httpClient, response});
        return byteArrayInputStream;
    }

    static {
        WechatMiniProgramFunctions.checkProperties((AbstractConfig)properties, WechatPayCoreProperties.class);
    }
}

