/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.wechat.jsapi.function;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.IOUtil;
import cn.minsin.wechat.jsapi.config.MutilsWechatJsapiProperties;
import cn.minsin.wechat.jsapi.model.JsapiOrderPayModel;
import cn.minsin.wechat.jsapi.model.JsapiRefundModel;
import cn.minsin.wechat.wechatpay.core.config.WechatPayCoreProperties;
import cn.minsin.wechat.wechatpay.core.function.WeChatPayFunctions;
import cn.minsin.wechat.wechatpay.core.model.AccessTokenModel;
import cn.minsin.wechat.wechatpay.core.model.PayModel;
import cn.minsin.wechat.wechatpay.core.model.RefundModel;
import cn.minsin.wechat.wechatpay.core.model.RefundReturnModel;
import cn.minsin.wechat.wechatpay.core.util.Sha1Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatJsapiFunctions
extends WeChatPayFunctions {
    private static final Logger log = LoggerFactory.getLogger(WechatJsapiFunctions.class);
    @Autowired
    private MutilsWechatJsapiProperties properties;
    @Autowired(required=false)
    private WechatPayCoreProperties coreProperties;

    @PostConstruct
    private void init() {
        if (this.coreProperties == null) {
            log.info("\u5fae\u4fe1\u652f\u4ed8\u76f8\u5173\u529f\u80fd\u65e0\u6cd5\u4f7f\u7528,\u5982\u9700\u4f7f\u7528\u8bf7\u5728properties\u4e2d\u914d\u7f6eWeChat\u914d\u7f6emutils.wechat.pay\u76f8\u5173\u5c5e\u6027");
        }
        super.setProperties(this.coreProperties);
    }

    public RefundReturnModel createJsapiRefundParamter(JsapiRefundModel model) throws MutilsErrorException, ClientProtocolException, IOException {
        model.setAppid(this.properties.getAppid());
        return super.createRefundRequest((RefundModel)model);
    }

    public Map<String, Object> createInitJSConfig(String url, boolean debug, String ... functions) throws ClientProtocolException, IOException {
        if (functions == null || functions.length == 0) {
            functions = new String[]{"openLocation", "getLocation", "chooseWXPay"};
        }
        String jsapi_ticket = this.getAccessToken().getJsapi_ticket();
        String nonce_str = String.valueOf(System.currentTimeMillis());
        Long timestamp = System.currentTimeMillis() / 1000L;
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("noncestr", nonce_str);
        packageParams.put("timestamp", timestamp.toString());
        packageParams.put("jsapi_ticket", jsapi_ticket);
        packageParams.put("url", url);
        String sign = Sha1Util.createSHA1Sign(packageParams);
        TreeMap<String, Object> returnMap = new TreeMap<String, Object>();
        returnMap.put("appId", this.properties.getAppid());
        returnMap.put("nonceStr", nonce_str);
        returnMap.put("timestamp", timestamp);
        returnMap.put("signature", sign);
        returnMap.put("jsApiList", functions);
        returnMap.put("debug", debug);
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTokenModel getAccessToken() throws ClientProtocolException, IOException {
        AccessTokenModel accessTokenModel;
        CloseableHttpClient instance = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String accessTokenUrl = this.properties.getAccessTokenUrl();
            String jsapiTicketUrl = this.properties.getJsapiTicketUrl();
            String appid = this.properties.getAppid();
            String appSecret = this.properties.getAppSecret();
            String requestUrl = accessTokenUrl.replace("APPID", appid).replace("APPSECRET", appSecret);
            HttpGet getMethod = HttpClientUtil.getGetMethod((String)requestUrl);
            response = instance.execute((HttpUriRequest)getMethod);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            JSONObject jsonObject = JSON.parseObject((String)string);
            String access_token = jsonObject.get((Object)"access_token").toString();
            String jsapi_ticketurl = jsapiTicketUrl.replace("ACCESS_TOKEN", access_token);
            getMethod = HttpClientUtil.getGetMethod((String)jsapi_ticketurl);
            string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            jsonObject = JSON.parseObject((String)string);
            String jsapi_ticke = jsonObject.get((Object)"ticket").toString();
            AccessTokenModel accessToken = new AccessTokenModel();
            accessToken.setAccess_token(access_token);
            accessToken.setExpires_in(7200);
            accessToken.setExpires_time(System.currentTimeMillis() / 1000L);
            accessToken.setJsapi_ticket(jsapi_ticke);
            accessTokenModel = accessToken;
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{instance, response});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{instance, response});
        return accessTokenModel;
    }

    public Map<String, String> createJsapiPayParamter(JsapiOrderPayModel model) throws ParseException, IOException, MutilsErrorException {
        model.setAppid(this.properties.getAppid());
        Map doXMLParse = super.createUnifiedOrder((PayModel)model);
        this.checkMap(doXMLParse);
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        String appId = (String)doXMLParse.get("appid");
        sortMap.put("appId", appId);
        sortMap.put("nonceStr", (String)doXMLParse.get("nonce_str"));
        sortMap.put("package", "prepay_id=" + (String)doXMLParse.get("prepay_id"));
        sortMap.put("signType", "MD5");
        sortMap.put("timeStamp", System.currentTimeMillis() / 1000L + "");
        sortMap.put("paySign", super.createSign(sortMap));
        sortMap.put("prepay_id", (String)doXMLParse.get("prepay_id"));
        return sortMap;
    }
}

