/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.wechat.jsapi;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.WechatJsapiConfig;
import cn.minsin.core.init.core.AbstractConfig;
import cn.minsin.core.tools.HttpClientUtil;
import cn.minsin.core.tools.IOUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.mutils.wechat.jsapi.model.AccessTokenModel;
import org.mutils.wechat.jsapi.model.JsapiOrderPayModel;
import org.mutils.wechat.jsapi.model.JsapiRefundModel;
import org.mutils.wechat.wechatpay.core.WeChatPayFunctions;
import org.mutils.wechat.wechatpay.core.model.BaseWeChatPayModel;
import org.mutils.wechat.wechatpay.core.model.RefundModel;
import org.mutils.wechat.wechatpay.core.model.RefundReturnModel;
import org.mutils.wechat.wechatpay.core.util.Sha1Util;

public class WechatJsapiFunctions
extends WeChatPayFunctions {
    private static final WechatJsapiConfig config = (WechatJsapiConfig)AbstractConfig.loadConfig(WechatJsapiConfig.class);

    public static RefundReturnModel createJsapiRefundParamter(JsapiRefundModel model) throws MutilsErrorException {
        return WechatJsapiFunctions.createRefundRequest((RefundModel)model);
    }

    public static Map<String, Object> createInitJSConfig(String url, boolean debug, String ... functions) throws MutilsErrorException {
        try {
            if (functions == null || functions.length == 0) {
                functions = new String[]{"openLocation", "getLocation", "chooseWXPay"};
            }
            String jsapi_ticket = WechatJsapiFunctions.getAccessToken().getJsapi_ticket();
            String nonce_str = String.valueOf(System.currentTimeMillis());
            Long timestamp = System.currentTimeMillis() / 1000L;
            TreeMap<String, String> packageParams = new TreeMap<String, String>();
            packageParams.put("noncestr", nonce_str);
            packageParams.put("timestamp", timestamp.toString());
            packageParams.put("jsapi_ticket", jsapi_ticket);
            packageParams.put("url", url);
            String sign = Sha1Util.createSHA1Sign(packageParams);
            TreeMap<String, Object> returnMap = new TreeMap<String, Object>();
            returnMap.put("appId", config.getAppid());
            returnMap.put("nonceStr", nonce_str);
            returnMap.put("timestamp", timestamp);
            returnMap.put("signature", sign);
            returnMap.put("jsApiList", functions);
            returnMap.put("debug", debug);
            return returnMap;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "jsapi\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public static AccessTokenModel getAccessToken() throws MutilsErrorException {
        AccessTokenModel accessTokenModel;
        CloseableHttpClient instance = HttpClientUtil.getInstance();
        CloseableHttpResponse response = null;
        try {
            String accessTokenUrl = config.getAccessTokenUrl();
            String jsapiTicketUrl = config.getJsapiTicketUrl();
            String appid = config.getAppid();
            String appSecret = config.getAppSecret();
            String requestUrl = accessTokenUrl.replace("APPID", appid).replace("APPSECRET", appSecret);
            HttpGet getMethod = HttpClientUtil.getGetMethod((String)requestUrl);
            response = instance.execute((HttpUriRequest)getMethod);
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            JSONObject jsonObject = JSON.parseObject((String)string);
            String access_token = jsonObject.get((Object)"access_token").toString();
            String jsapi_ticketurl = jsapiTicketUrl.replace("ACCESS_TOKEN", access_token);
            getMethod = HttpClientUtil.getGetMethod((String)jsapi_ticketurl);
            string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            jsonObject = JSON.parseObject((String)string);
            String jsapi_ticke = jsonObject.get((Object)"ticket").toString();
            AccessTokenModel accessToken = new AccessTokenModel();
            accessToken.setAccess_token(access_token);
            accessToken.setExpires_in(7200);
            accessToken.setExpires_time(System.currentTimeMillis() / 1000L);
            accessToken.setJsapi_ticket(jsapi_ticke);
            accessTokenModel = accessToken;
        }
        catch (Exception e) {
            try {
                throw new MutilsErrorException((Throwable)e, "\u83b7\u53d6AccessToken\u5931\u8d25");
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{instance, response});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{instance, response});
        return accessTokenModel;
    }

    public static Map<String, String> createJsapiPayParamter(JsapiOrderPayModel model) throws MutilsErrorException {
        try {
            Map doXMLParse = WechatJsapiFunctions.createUnifiedOrder((BaseWeChatPayModel)model);
            WechatJsapiFunctions.checkMap((Map)doXMLParse);
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            String appId = (String)doXMLParse.get("appid");
            sortMap.put("appId", appId);
            sortMap.put("nonceStr", (String)doXMLParse.get("nonce_str"));
            sortMap.put("package", "prepay_id=" + (String)doXMLParse.get("prepay_id"));
            sortMap.put("signType", "MD5");
            sortMap.put("timeStamp", System.currentTimeMillis() / 1000L + "");
            sortMap.put("paySign", WechatJsapiFunctions.createSign(sortMap));
            sortMap.put("prepay_id", (String)doXMLParse.get("prepay_id"));
            return sortMap;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u53d1\u8d77JSAPI\u652f\u4ed8\u5931\u8d25");
        }
    }
}

