/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.wechat.jsapi;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.WechatJsapiConfig;
import cn.minsin.core.init.WechatPayCoreConfig;
import cn.minsin.core.init.core.InitConfig;
import cn.minsin.core.tools.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.mutils.wechat.jsapi.model.AccessTokenModel;
import org.mutils.wechat.jsapi.model.JsapiOrderPayModel;
import org.mutils.wechat.jsapi.model.JsapiRefundModel;
import org.mutils.wechat.wechatpay.core.WeChatPayFunctions;
import org.mutils.wechat.wechatpay.core.model.BaseWeChatPayModel;
import org.mutils.wechat.wechatpay.core.model.RefundModel;
import org.mutils.wechat.wechatpay.core.util.Sha1Util;
import org.mutils.wechat.wechatpay.core.util.SignUtil;

public class WechatJsapiFunctions
extends WeChatPayFunctions {
    public static Map<String, String> createMiniProgramRefundParamter(JsapiRefundModel model) throws MutilsErrorException {
        WechatJsapiFunctions.checkConfig((String)"WechatJsapiFunctions", (InitConfig)WechatJsapiConfig.wechatJsapiConfig);
        return WechatJsapiFunctions.createRefundRequest((RefundModel)model);
    }

    public static Map<String, Object> createInitJSConfig(String url, boolean debug, String ... functions) throws MutilsErrorException {
        WechatJsapiFunctions.checkConfig((String)"WechatJsapiFunctions", (InitConfig)WechatJsapiConfig.wechatJsapiConfig);
        try {
            if (functions == null || functions.length == 0) {
                functions = new String[]{"openLocation", "getLocation", "chooseWXPay"};
            }
            String jsapi_ticket = WechatJsapiFunctions.getAccessToken().getJsapi_ticket();
            String nonce_str = String.valueOf(System.currentTimeMillis());
            Long timestamp = System.currentTimeMillis() / 1000L;
            TreeMap<String, String> packageParams = new TreeMap<String, String>();
            packageParams.put("noncestr", nonce_str);
            packageParams.put("timestamp", timestamp.toString());
            packageParams.put("jsapi_ticket", jsapi_ticket);
            packageParams.put("url", url);
            String sign = Sha1Util.createSHA1Sign(packageParams);
            TreeMap<String, Object> returnMap = new TreeMap<String, Object>();
            returnMap.put("appId", WechatJsapiConfig.wechatJsapiConfig.getAppid());
            returnMap.put("nonceStr", nonce_str);
            returnMap.put("timestamp", timestamp);
            returnMap.put("signature", sign);
            returnMap.put("jsApiList", functions);
            returnMap.put("debug", false);
            return returnMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AccessTokenModel getAccessToken() throws Exception {
        WechatJsapiFunctions.checkConfig((String)"WechatJsapiFunctions", (InitConfig)WechatJsapiConfig.wechatJsapiConfig);
        try (CloseableHttpClient instance = HttpClientUtil.getInstance();){
            String accessTokenUrl = WechatJsapiConfig.wechatJsapiConfig.getAccessTokenUrl();
            String jsapiTicketUrl = WechatJsapiConfig.wechatJsapiConfig.getJsapiTicketUrl();
            String appid = WechatJsapiConfig.wechatJsapiConfig.getAppid();
            String appSecret = WechatJsapiConfig.wechatJsapiConfig.getAppSecret();
            String requestUrl = accessTokenUrl.replace("APPID", appid).replace("APPSECRET", appSecret);
            HttpGet getMethod = HttpClientUtil.getGetMethod((String)requestUrl);
            String string = EntityUtils.toString((HttpEntity)instance.execute((HttpUriRequest)getMethod).getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            JSONObject jsonObject = JSON.parseObject((String)string);
            String access_token = jsonObject.get((Object)"access_token").toString();
            String jsapi_ticketurl = jsapiTicketUrl.replace("ACCESS_TOKEN", access_token);
            getMethod = HttpClientUtil.getGetMethod((String)jsapi_ticketurl);
            string = EntityUtils.toString((HttpEntity)instance.execute((HttpUriRequest)getMethod).getEntity(), (String)"UTF-8");
            getMethod.releaseConnection();
            jsonObject = JSON.parseObject((String)string);
            String jsapi_ticke = jsonObject.get((Object)"ticket").toString();
            AccessTokenModel accessToken = new AccessTokenModel();
            accessToken.setAccess_token(access_token);
            accessToken.setExpires_in(7200);
            accessToken.setExpires_time(System.currentTimeMillis() / 1000L);
            accessToken.setJsapi_ticket(jsapi_ticke);
            AccessTokenModel accessTokenModel = accessToken;
            return accessTokenModel;
        }
    }

    public static Map<String, String> createJSAPIPayParamter(JsapiOrderPayModel model) throws MutilsErrorException {
        WechatJsapiFunctions.checkConfig((String)"WechatJsapiFunctions", (InitConfig)WechatJsapiConfig.wechatJsapiConfig);
        try {
            Map doXMLParse = WechatJsapiFunctions.createUnifiedOrder((BaseWeChatPayModel)model);
            WechatJsapiFunctions.checkMap((Map)doXMLParse);
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            String appId = (String)doXMLParse.get("appid");
            sortMap.put("appId", appId);
            sortMap.put("nonceStr", (String)doXMLParse.get("nonce_str"));
            sortMap.put("package", "prepay_id=" + (String)doXMLParse.get("prepay_id"));
            sortMap.put("signType", "MD5");
            sortMap.put("timeStamp", System.currentTimeMillis() / 1000L + "");
            String sign = SignUtil.createSign(sortMap, (String)WechatPayCoreConfig.wechatPayConfig.getPartnerKey());
            sortMap.put("paySign", sign);
            sortMap.put("prepay_id", (String)doXMLParse.get("prepay_id"));
            return sortMap;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u53d1\u8d77JSAPI\u652f\u4ed8\u5931\u8d25");
        }
    }
}

