/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.wechat.jsapi.config;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.core.AbstractConfig;
import cn.minsin.core.tools.StringUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="mutils.wechat.jsapi")
public class MutilsWechatJsapiProperties
extends AbstractConfig {
    private String appid;
    private String appSecret;
    private String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
    private String jsapiTicketUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";

    protected void checkConfig() {
        slog.info("Required for initialization appid,appSecret");
        if (StringUtil.isBlank((Object[])new Object[]{this.appid, this.appSecret})) {
            throw new MutilsException("The wechat-jsapi config was initialization failed.");
        }
    }

    public String getAppid() {
        return this.appid;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getJsapiTicketUrl() {
        return this.jsapiTicketUrl;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public void setJsapiTicketUrl(String jsapiTicketUrl) {
        this.jsapiTicketUrl = jsapiTicketUrl;
    }
}

