/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.spring.boot.autoconfigure;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.MutilsFunctions;
import cn.minsin.spring.boot.autoconfigure.MutilsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MutilsProperties.class})
public class MutilsAutoConfigure {

    @Configuration
    static class MutilsParamConfiguration {
        private Logger log = LoggerFactory.getLogger(MutilsParamConfiguration.class);
        private final MutilsProperties properties;

        MutilsParamConfiguration(MutilsProperties properties) {
            this.properties = properties;
            this.init();
        }

        public void init() {
            MutilsFunctions[] functions;
            this.log.info("\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684function\u53c2\u6570\u914d\u7f6e\u4e4b\u540e\u624d\u80fd\u521d\u59cb\u5316. Choosed functions will be initialize.");
            for (MutilsFunctions mutilsFunctions : functions = this.properties.getFunctions()) {
                String name = mutilsFunctions.getName();
                int index = mutilsFunctions.getIndex();
                try {
                    Object init = null;
                    switch (index) {
                        case 1: {
                            init = this.properties.getAlipay();
                            break;
                        }
                        case 2: {
                            init = this.properties.getWechatPayCore();
                            break;
                        }
                        case 3: {
                            init = this.properties.getExcel();
                            break;
                        }
                        case 4: {
                            init = this.properties.getFile();
                            break;
                        }
                        case 5: {
                            init = this.properties.getKuaidi100();
                            break;
                        }
                        case 6: {
                            init = this.properties.getYiketong();
                            break;
                        }
                        case 7: {
                            init = this.properties.getDianwoda();
                            break;
                        }
                        case 8: {
                            init = this.properties.getWechatMiniProgram();
                        }
                    }
                    init.done();
                    this.log.info("{} \u529f\u80fd\u521d\u59cb\u5316\u6210\u529f.{} was initialize successful.", (Object)name, (Object)name);
                }
                catch (Exception e) {
                    throw new MutilsException((Throwable)e, name + " was initialize failed,Please check properties.");
                }
            }
        }

        public MutilsProperties getProperties() {
            return this.properties;
        }
    }
}

