/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.pinyin.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class PinyinResult {
    private static final long serialVersionUID = 8001335658359626567L;
    private Set<String> firstLetter = new HashSet<String>();
    private Set<String> fullLetter = new HashSet<String>();
    private TreeMap<Integer, String[]> multiLetter = new TreeMap();
    private int length;
    private String source;

    public PinyinResult(int length, String source) {
        this.length = length;
        this.source = source;
    }

    public PinyinResult() {
    }

    public String getSource() {
        return this.source;
    }

    public TreeMap<Integer, String[]> getMultiLetter() {
        return this.multiLetter;
    }

    public void setMultiLetter(int index, String[] result) {
        this.multiLetter.put(index, result);
    }

    public int getLength() {
        return this.length;
    }

    public Set<String> getFirstLetter() {
        return this.firstLetter;
    }

    public void setFirstLetter(String[] firstLetter) {
        this.firstLetter.addAll(Arrays.asList(firstLetter));
    }

    public Set<String> getFullLetter() {
        return this.fullLetter;
    }

    public void setFullLetter(String[] fullLetter) {
        this.fullLetter.addAll(Arrays.asList(fullLetter));
    }

    public synchronized void resolve() {
        String[] strings;
        int index = 0;
        String[] fillLetter = null;
        String[] firstLetter = null;
        while ((strings = this.multiLetter.get(index)) != null) {
            fillLetter = this.fillLetter(fillLetter, strings);
            firstLetter = this.firstLetter(firstLetter, this.subString1(strings));
            if (index >= this.length) break;
            ++index;
        }
        this.setFullLetter(fillLetter);
        this.setFirstLetter(firstLetter);
    }

    private String[] fillLetter(String[] a, String[] b) {
        if (a == null && b == null) {
            return b;
        }
        if (a == null) {
            return b;
        }
        String[] s = new String[a.length * b.length];
        int index = 0;
        for (String string : a) {
            for (String string2 : b) {
                s[index] = string + " " + string2;
                ++index;
            }
        }
        return s;
    }

    private String[] firstLetter(String[] a, String[] b) {
        if (a == null && b == null) {
            return b;
        }
        if (a == null) {
            return b;
        }
        String[] s = new String[a.length * b.length];
        int index = 0;
        for (String string : a) {
            for (String string2 : b) {
                s[index] = string + string2.substring(0, 1);
                ++index;
            }
        }
        return s;
    }

    private String[] subString1(String[] s) {
        String[] result = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = s[i].substring(0, 1);
        }
        return result;
    }
}

