/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.pinyin;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.rule.AbstractFunctionRule;
import cn.minsin.core.tools.StringUtil;
import cn.minsin.pinyin.model.PinyinResult;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinFunctions
extends AbstractFunctionRule {
    public static String getFirstLetter(String chinese, HanyuPinyinCaseType type, String defaultValue) {
        MutilsException.throwException((boolean)StringUtil.isBlank((CharSequence)chinese), (String)"\u6c49\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        char[] cl_chars = chinese.trim().toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(type == null ? HanyuPinyinCaseType.LOWERCASE : type);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            String str = String.valueOf(cl_chars[0]);
            if (str.matches("[\u4e00-\u9fa5]+")) {
                return PinyinHelper.toHanyuPinyinStringArray((char)cl_chars[0], (HanyuPinyinOutputFormat)defaultFormat)[0].substring(0, 1);
            }
            if (str.matches("[a-zA-Z]+")) {
                return String.valueOf(cl_chars[0]);
            }
            if (str.matches("[0-9]+")) {
                return defaultValue;
            }
            return defaultValue;
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new MutilsException((Throwable)e);
        }
    }

    public static PinyinResult parseChineseStr(String chinese, HanyuPinyinOutputFormat format) {
        chinese = StringUtil.pickUpChinese((String)chinese);
        MutilsException.throwException((boolean)StringUtil.isBlank((CharSequence)chinese), (String)"\u6c49\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        char[] nameChar = chinese.toCharArray();
        PinyinResult pinyinResult = new PinyinResult(nameChar.length, chinese);
        if (format == null) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        }
        for (int i = 0; i < nameChar.length; ++i) {
            if (nameChar[i] <= '\u0080') continue;
            try {
                String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)nameChar[i], (HanyuPinyinOutputFormat)format);
                if (strs == null) continue;
                pinyinResult.setMultiLetter(i, strs);
                continue;
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                e.printStackTrace();
            }
        }
        pinyinResult.resolve();
        return pinyinResult;
    }
}

