/*
 * Decompiled with CFR 0.152.
 */
package cn.mutils.meituan.peisong.sign;

import cn.minsin.core.tools.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SignUtil {
    public static String generateSign(Map<String, String> params, String secret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String encodeString = SignUtil.getEncodeString(params, secret);
        String sign = SignUtil.generateSign(encodeString);
        return sign;
    }

    private static String getEncodeString(Map<String, String> params, String secret) {
        Iterator<String> keyIter = params.keySet().iterator();
        TreeSet<String> sortedParams = new TreeSet<String>();
        while (keyIter.hasNext()) {
            sortedParams.add(keyIter.next());
        }
        StringBuilder strB = new StringBuilder(secret);
        for (String key : sortedParams) {
            String value;
            if (key.equals("sign") || !StringUtil.isNotBlank((CharSequence)(value = params.get(key)))) continue;
            strB.append(key).append(value);
        }
        return strB.toString();
    }

    private static String generateSign(String content) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return SignUtil.Sha1(content).toLowerCase();
    }

    private static String Sha1(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] btInput = s.getBytes("utf-8");
        MessageDigest mdInst = MessageDigest.getInstance("sha-1");
        mdInst.update(btInput);
        byte[] md = mdInst.digest();
        int j = md.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }
}

