/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.gexin.push;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.init.GexinPushConfig;
import cn.minsin.core.init.core.InitConfig;
import cn.minsin.core.rule.FunctionRule;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.ListMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import java.util.ArrayList;
import java.util.List;
import org.mutils.gexin.push.model.PushModel;

public class GexinPushFunctions
extends FunctionRule {
    private static final GexinPushConfig config = (GexinPushConfig)InitConfig.loadConfig(GexinPushConfig.class);

    protected static IGtPush initPush() {
        return new IGtPush(config.getUrl(), config.getAppkey(), config.getMasterSecret());
    }

    public static IPushResult pushSingle(PushModel model) throws MutilsErrorException {
        model.setPushMany(false);
        return GexinPushFunctions.push(model);
    }

    public static IPushResult pushMany(PushModel model) throws MutilsErrorException {
        model.setPushMany(true);
        return GexinPushFunctions.push(model);
    }

    public static IPushResult push(PushModel model) throws MutilsErrorException {
        model.verificationField();
        IGtPush push = GexinPushFunctions.initPush();
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(config.getAppid());
        template.setAppkey(config.getAppkey());
        template.setTransmissionType(model.getTransmissionType());
        template.setTransmissionContent(model.getContent());
        APNPayload payload = new APNPayload();
        payload.setContentAvailable(1);
        payload.setSound(model.getSound());
        payload.setCategory(model.getContent());
        payload.setAlertMsg((APNPayload.AlertMsg)new APNPayload.SimpleAlertMsg(model.getTitle()));
        template.setAPNInfo((Payload)payload);
        List<String> clientids = model.getClientids();
        if (clientids.isEmpty()) {
            throw new MutilsErrorException("clientid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            boolean pushMany = model.isPushMany();
            if (!pushMany) {
                SingleMessage message = new SingleMessage();
                message.setOffline(true);
                message.setOfflineExpireTime(model.getTimeout());
                message.setData((ITemplate)template);
                message.setPushNetWorkType(model.getPushNetWorkType());
                Target target = new Target();
                target.setAppId(config.getAppid());
                target.setClientId(clientids.get(0));
                return push.pushMessageToSingle(message, target);
            }
            ListMessage message = new ListMessage();
            message.setOffline(true);
            message.setOfflineExpireTime(model.getTimeout());
            message.setData((ITemplate)template);
            message.setPushNetWorkType(model.getPushNetWorkType());
            ArrayList<Target> targets = new ArrayList<Target>();
            for (String clientid : clientids) {
                Target target = new Target();
                target.setAppId(config.getAppid());
                target.setClientId(clientid);
                targets.add(target);
            }
            String contentId = push.getContentId(message);
            return push.pushMessageToList(contentId, targets);
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "\u63a8\u9001\u5931\u8d25");
        }
    }
}

