/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.tools;

import cn.minsin.core.tools.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static InputStream getExcelTemplate(String excelPath, boolean isInDisk) throws FileNotFoundException {
        if (isInDisk) {
            return new FileInputStream(excelPath);
        }
        return ExcelUtil.class.getClassLoader().getResourceAsStream(excelPath);
    }

    public static String getCellRealValue(Cell cell) {
        String cellValue;
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue()));
                    break;
                }
                DataFormatter dataFormatter = new DataFormatter();
                cellValue = dataFormatter.formatCellValue(cell);
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                cellValue = cell.getCellFormula() + "";
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return StringUtil.filterSpace((String)cellValue);
    }

    public static Workbook parseInputStreamToWorkBook(InputStream inputStream) throws IOException {
        return WorkbookFactory.create((InputStream)inputStream);
    }

    public static Workbook parseFileToWorkBook(File file) throws IOException {
        return WorkbookFactory.create((File)file);
    }

    public static void copyRow(Row fromRow, Row toRow, boolean copyValueFlag) {
        toRow.setHeight(fromRow.getHeight());
        Workbook workbook = fromRow.getSheet().getWorkbook();
        Iterator cellIt = fromRow.cellIterator();
        while (cellIt.hasNext()) {
            Cell tmpCell = (Cell)cellIt.next();
            Cell newCell = toRow.createCell(tmpCell.getColumnIndex());
            ExcelUtil.copyCell(workbook, tmpCell, newCell, copyValueFlag);
        }
    }

    public static void copyCell(Workbook wb, Cell srcCell, Cell distCell, boolean copyValueFlag) {
        CellStyle newStyle = wb.createCellStyle();
        CellStyle srcStyle = srcCell.getCellStyle();
        newStyle.cloneStyleFrom(srcStyle);
        newStyle.setFont(wb.getFontAt(srcStyle.getFontIndexAsInt()));
        distCell.setCellStyle(newStyle);
        if (srcCell.getCellComment() != null) {
            distCell.setCellComment(srcCell.getCellComment());
        }
        CellType cellType = srcCell.getCellType();
        distCell.setCellType(cellType);
        if (copyValueFlag) {
            if (cellType == CellType.NUMERIC) {
                if (HSSFDateUtil.isCellDateFormatted((Cell)srcCell)) {
                    distCell.setCellValue(srcCell.getDateCellValue());
                } else {
                    distCell.setCellValue(srcCell.getNumericCellValue());
                }
            } else if (cellType == CellType.STRING) {
                distCell.setCellValue(srcCell.getRichStringCellValue());
            } else if (cellType == CellType.BOOLEAN) {
                distCell.setCellValue(srcCell.getBooleanCellValue());
            } else if (cellType == CellType.ERROR) {
                distCell.setCellErrorValue(srcCell.getErrorCellValue());
            } else if (cellType == CellType.FORMULA) {
                distCell.setCellFormula(srcCell.getCellFormula());
            } else {
                distCell.setCellValue(srcCell.getStringCellValue());
            }
        }
    }

    public static void setCellValue(Row row, int cellIndex, CellType cellType, Object value, Consumer<CellStyle> function) {
        Cell cell = row.getCell(cellIndex);
        if (cell == null) {
            cell = row.createCell(cellIndex);
        }
        cell.setCellType(cellType);
        if (function != null) {
            CellStyle cellStyle = row.getSheet().getWorkbook().createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setWrapText(true);
            function.accept(cellStyle);
            cell.setCellStyle(cellStyle);
        }
        if (value == null) {
            cell.setCellValue("");
        } else if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else {
            cell.setCellValue(value.toString());
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T workbookToInputStream(@NonNull Workbook workbook, @NonNull Function<InputStream, T> convert) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void workbookToInputStream(@NonNull Workbook workbook, @NonNull Consumer<InputStream> convert) throws Exception {
        if (workbook == null) {
            throw new NullPointerException("workbook");
        }
        if (convert == null) {
            throw new NullPointerException("convert");
        }
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            try {
                workbook.write((OutputStream)byteOutputStream);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                try {
                    convert.accept(inputStream);
                }
                finally {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(byteOutputStream).get(0) != null) {
                    byteOutputStream.close();
                }
            }
        }
        finally {
            if (workbook != null) {
                workbook.close();
            }
        }
    }

    public static void workbookToServletResponse(@NonNull Workbook workbook, @NonNull HttpServletResponse httpServletResponse, @NonNull String fileName, Function<String, String> nameFunction) throws Exception {
        if (workbook == null) {
            throw new NullPointerException("workbook");
        }
        if (httpServletResponse == null) {
            throw new NullPointerException("httpServletResponse");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        String newName = nameFunction == null ? fileName : new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        ExcelUtil.workbookToServletResponse(workbook, httpServletResponse, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void workbookToServletResponse(@NonNull Workbook workbook, @NonNull HttpServletResponse httpServletResponse, @NonNull String fileName) throws Exception {
        if (workbook == null) {
            throw new NullPointerException("workbook");
        }
        if (httpServletResponse == null) {
            throw new NullPointerException("httpServletResponse");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        try {
            httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
            httpServletResponse.setContentType("application/x-msdownload; charset=utf-8");
            httpServletResponse.setHeader("content-disposition", "attachment;filename=" + fileName);
            ServletOutputStream outputStream = httpServletResponse.getOutputStream();
            workbook.write((OutputStream)outputStream);
        }
        finally {
            if (workbook != null) {
                workbook.close();
            }
        }
    }
}

