/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.model.create;

import cn.minsin.excel.function.creator.RowCellCreator;
import cn.minsin.excel.function.creator.SheetCreator;
import cn.minsin.excel.model.create.CellTitle;
import cn.minsin.excel.model.create.FiledParse;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellType;

public interface ExcelExportTemplate {
    default public void create(SheetCreator sheetCreator, int rowIndex) throws IllegalAccessException {
        RowCellCreator rowCellCreator = sheetCreator.creatorRow(rowIndex);
        List<FiledParse> parse = this.parse();
        for (int i = 0; i < parse.size(); ++i) {
            rowCellCreator.cell(i, CellType.STRING, parse.get(i).getValue());
        }
    }

    default public List<FiledParse> parse() throws IllegalAccessException {
        Field[] declaredFields = this.getClass().getDeclaredFields();
        ArrayList<FiledParse> filedParses = new ArrayList<FiledParse>(declaredFields.length);
        for (Field declaredField : declaredFields) {
            CellTitle annotation = declaredField.getAnnotation(CellTitle.class);
            if (annotation == null) continue;
            declaredField.setAccessible(true);
            Object o = declaredField.get(this);
            filedParses.add(new FiledParse(annotation, o));
        }
        filedParses.trimToSize();
        return filedParses;
    }
}

