/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.model;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.excel.model.ExcelSheetModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExcelParseResultModel {
    private List<ExcelSheetModel> sheets = new ArrayList<ExcelSheetModel>(3);
    protected Map<String, ExcelSheetModel> cache;
    protected static String INDEX_SUFFIX = "$INDEX_";
    protected static String NAME_SUFFIX = "$NAME_";

    public void addSheet(ExcelSheetModel model) {
        this.sheets.add(model);
    }

    protected void initCache() {
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap<String, ExcelSheetModel>(this.sheets.size());
            for (ExcelSheetModel cell : this.sheets) {
                this.cache.put(INDEX_SUFFIX.concat(String.valueOf(cell.getSheetIndex())), cell);
                this.cache.put(NAME_SUFFIX.concat(cell.getSheetName()), cell);
            }
        }
    }

    public ExcelSheetModel findSheet(String sheetName) {
        this.initCache();
        String concat = NAME_SUFFIX.concat(sheetName);
        boolean b = this.cache.containsKey(concat);
        MutilsException.throwException((!b ? 1 : 0) != 0, (String)("sheetName\u4e3a'" + sheetName + "'\u4e0d\u5b58\u5728"));
        return this.cache.get(concat);
    }

    public ExcelSheetModel findSheet(int sheetIndex) {
        this.initCache();
        String concat = INDEX_SUFFIX.concat(String.valueOf(sheetIndex));
        boolean b = this.cache.containsKey(concat);
        MutilsException.throwException((!b ? 1 : 0) != 0, (String)("sheetIndex\u4e3a'" + sheetIndex + "'\u4e0d\u5b58\u5728"));
        return this.cache.get(concat);
    }

    public String toString() {
        return "ExcelParseResultModel(sheets=" + this.getSheets() + ", cache=" + this.cache + ")";
    }

    public List<ExcelSheetModel> getSheets() {
        return this.sheets;
    }

    public void setSheets(List<ExcelSheetModel> sheets) {
        this.sheets = sheets;
    }
}

