/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.function.creator;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.tools.ListUtil;
import cn.minsin.excel.function.ExcelCreateFunctions;
import cn.minsin.excel.function.creator.BaseCreator;
import cn.minsin.excel.function.creator.GetWorkbook;
import cn.minsin.excel.function.creator.RowCellCreator;
import cn.minsin.excel.model.create.ExcelExportTemplate;
import cn.minsin.excel.model.create.FiledParse;
import cn.minsin.excel.tools.ExcelUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class SheetCreator
extends BaseCreator
implements GetWorkbook {
    private final ConcurrentHashMap<String, Integer> mergedRegion = new ConcurrentHashMap(10);
    private final Sheet sheet;
    private final ExcelCreateFunctions excelCreateFunctions;
    private final AtomicInteger startRowIndex;

    public SheetCreator(Sheet sheet, ExcelCreateFunctions excelCreateFunctions, int startRowIndex) {
        super(excelCreateFunctions.workbook, excelCreateFunctions.excelVersion);
        this.sheet = sheet;
        this.excelCreateFunctions = excelCreateFunctions;
        this.startRowIndex = new AtomicInteger(startRowIndex);
    }

    public RowCellCreator creatorRowWithAutoGrow() {
        Row row = this.sheet.createRow(this.startRowIndex.addAndGet(1));
        return new RowCellCreator(row, this);
    }

    public RowCellCreator cloneRowWithAutoGrow(int targetIndex, boolean afterRemove) {
        Row row = this.sheet.getRow(targetIndex);
        if (afterRemove) {
            this.sheet.removeRow(row);
        }
        Row newRow = this.sheet.createRow(this.startRowIndex.addAndGet(1));
        ExcelUtil.copyRow(row, newRow, true);
        return new RowCellCreator(row, this);
    }

    public SheetCreator addRowByListWithAutoGrow(List<? extends ExcelExportTemplate> listData) throws IllegalAccessException {
        return this.addRowByListWithAutoGrow(listData, false);
    }

    public SheetCreator addRowByListWithAutoGrow(List<? extends ExcelExportTemplate> listData, boolean needTitle) throws IllegalAccessException {
        MutilsException.throwException((boolean)ListUtil.isEmpty(listData), (String)"\u9700\u8981\u751f\u6210Excel\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        int title = 0;
        if (needTitle) {
            title = 1;
            List<FiledParse> parse = listData.get(0).parse();
            RowCellCreator rowCellCreator = this.creatorRowWithAutoGrow();
            for (int i = 0; i < parse.size(); ++i) {
                rowCellCreator.cell(i, CellType.STRING, parse.get(i).getCellTitle().value());
            }
        }
        for (int i = 0; i < listData.size(); ++i) {
            listData.get(i).create(this, i + this.startRowIndex.addAndGet(1) + title);
        }
        return this;
    }

    public RowCellCreator creatorRow(int index) {
        Row row = this.sheet.createRow(index);
        return new RowCellCreator(row, this);
    }

    public RowCellCreator getRow(int index, boolean afterRemove) {
        Row row = this.sheet.getRow(index);
        if (afterRemove) {
            this.sheet.removeRow(row);
        }
        return new RowCellCreator(row, this);
    }

    public RowCellCreator cloneRow(int targetIndex, int newIndex, boolean afterRemove) {
        Row row = this.sheet.getRow(targetIndex);
        if (afterRemove) {
            this.sheet.removeRow(row);
        }
        Row newRow = this.sheet.createRow(newIndex);
        ExcelUtil.copyRow(row, newRow, true);
        return new RowCellCreator(row, this);
    }

    public SheetCreator addMergedRegion(String name, int startRowIndex, int endRowIndex, int startColIndex, int endColIndex, boolean isSafe) {
        MutilsException.throwException((boolean)this.mergedRegion.containsKey(name), (String)("\u5b58\u5728\u76f8\u540c\u7684key\u5355\u5143\u683c\u540d\u79f0'" + name + "'"));
        CellRangeAddress cellAddresses = new CellRangeAddress(startRowIndex, endRowIndex, startColIndex, endColIndex);
        int i = isSafe ? this.sheet.addMergedRegion(cellAddresses) : this.sheet.addMergedRegionUnsafe(cellAddresses);
        this.mergedRegion.put(name, i);
        return this;
    }

    public SheetCreator addMergedRegion(String name, int startRowIndex, int endRowIndex, int startColIndex, int endColIndex) {
        this.addMergedRegion(name, startRowIndex, endRowIndex, startColIndex, endColIndex, false);
        return this;
    }

    public SheetCreator removeMergedRegion(String name) {
        this.mergedRegion.computeIfPresent(name, (k, v) -> {
            this.sheet.removeMergedRegion(v.intValue());
            this.mergedRegion.remove(name);
            return null;
        });
        return this;
    }

    public SheetCreator sheetConsumer(Consumer<Sheet> consumer) {
        consumer.accept(this.sheet);
        return this;
    }

    public SheetCreator addRowByList(List<? extends ExcelExportTemplate> listData) throws IllegalAccessException {
        return this.addRowByList(listData, 0, false);
    }

    public SheetCreator addRowByList(List<? extends ExcelExportTemplate> listData, int startRowIndex, boolean needTitle) throws IllegalAccessException {
        MutilsException.throwException((boolean)ListUtil.isEmpty(listData), (String)"\u9700\u8981\u751f\u6210Excel\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        int title = 0;
        if (needTitle) {
            title = 1;
            List<FiledParse> parse = listData.get(0).parse();
            RowCellCreator rowCellCreator = this.creatorRow(startRowIndex);
            for (int i = 0; i < parse.size(); ++i) {
                rowCellCreator.cell(i, CellType.STRING, parse.get(i).getCellTitle().value());
            }
        }
        for (int i = 0; i < listData.size(); ++i) {
            listData.get(i).create(this, i + startRowIndex + title);
        }
        return this;
    }

    @Override
    public Workbook getWorkbook() {
        return this.sheet.getWorkbook();
    }

    public ConcurrentHashMap<String, Integer> getMergedRegion() {
        return this.mergedRegion;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public ExcelCreateFunctions getExcelCreateFunctions() {
        return this.excelCreateFunctions;
    }

    public AtomicInteger getStartRowIndex() {
        return this.startRowIndex;
    }
}

