/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.function.creator;

import cn.minsin.excel.function.creator.BaseCreator;
import cn.minsin.excel.function.creator.SheetCreator;
import cn.minsin.excel.tools.ExcelUtil;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class RowCellCreator
extends BaseCreator {
    private final Row row;
    private final SheetCreator sheetCreator;

    public RowCellCreator(Row row, SheetCreator sheetCreator) {
        super(sheetCreator.workbook, sheetCreator.excelVersion);
        this.row = row;
        this.sheetCreator = sheetCreator;
    }

    public RowCellCreator cell(int index, CellType cellType, Object value) {
        return this.cell(index, cellType, value, null);
    }

    public RowCellCreator cell(int index, CellType cellType, Object value, Consumer<CellStyle> cellStyle) {
        ExcelUtil.setCellValue(this.row, index, cellType, value, cellStyle);
        return this;
    }

    public RowCellCreator removeCell(int index) {
        this.removeCell(index);
        return this;
    }

    public RowCellCreator setCellStyle(int collIndex, Consumer<CellStyle> cellStyleFunction) {
        Cell cell = this.row.getCell(collIndex);
        CellStyle cellStyle = this.createCellStyle();
        cellStyleFunction.accept(cellStyle);
        cell.setCellStyle(cellStyle);
        return this;
    }

    public RowCellCreator setRowStyle(Consumer<CellStyle> cellStyleFunction) {
        CellStyle cellStyle = this.createCellStyle();
        cellStyleFunction.accept(cellStyle);
        this.row.setRowStyle(cellStyle);
        return this;
    }

    public RowCellCreator cell(Consumer<Row> consumer) {
        consumer.accept(this.row);
        return this;
    }

    @Override
    public Workbook getWorkbook() {
        return this.row.getSheet().getWorkbook();
    }

    public CellStyle createCellStyle() {
        return this.getWorkbook().createCellStyle();
    }

    public Row getRow() {
        return this.row;
    }

    public SheetCreator getSheetCreator() {
        return this.sheetCreator;
    }
}

