/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.function.creator;

import cn.minsin.core.tools.IOUtil;
import cn.minsin.excel.enums.ExcelVersion;
import cn.minsin.excel.function.creator.GetWorkbook;
import cn.minsin.excel.tools.ExcelUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;

public class BaseCreator
implements GetWorkbook {
    protected Workbook workbook;
    protected ExcelVersion excelVersion;

    public String getVersionSuffix() {
        return this.excelVersion.getSuffix();
    }

    public void export(OutputStream outputStream) throws IOException {
        try {
            this.workbook.write(outputStream);
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{this.workbook, outputStream});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{this.workbook, outputStream});
    }

    public void export(HttpServletResponse resp, String fileName) throws Exception {
        ExcelUtil.workbookToServletResponse(this.workbook, resp, fileName);
    }

    public void exportWithUTF8(HttpServletResponse resp, String fileName) throws Exception {
        ExcelUtil.workbookToServletResponse(this.workbook, resp, new String(fileName.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
    }

    public <T> T toInputStream(@NonNull Function<InputStream, T> convert) throws Exception {
        if (convert == null) {
            throw new NullPointerException("convert");
        }
        return ExcelUtil.workbookToInputStream(this.workbook, convert);
    }

    public InputStream toInputStream() throws Exception {
        return ExcelUtil.workbookToInputStream(this.workbook, e -> e);
    }

    public void toInputStream(@NonNull Consumer<InputStream> convert) throws Exception {
        if (convert == null) {
            throw new NullPointerException("convert");
        }
        ExcelUtil.workbookToInputStream(this.workbook, convert);
    }

    public <T> T uploadToOss(@NonNull Function<InputStream, T> convert) throws Exception {
        if (convert == null) {
            throw new NullPointerException("convert");
        }
        return ExcelUtil.workbookToInputStream(this.workbook, convert);
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }

    public BaseCreator(Workbook workbook, ExcelVersion excelVersion) {
        this.workbook = workbook;
        this.excelVersion = excelVersion;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setExcelVersion(ExcelVersion excelVersion) {
        this.excelVersion = excelVersion;
    }
}

