/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.function;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.excel.model.ExcelCellModel;
import cn.minsin.excel.model.ExcelParseResultModel;
import cn.minsin.excel.model.ExcelRowModel;
import cn.minsin.excel.model.ExcelSheetModel;
import cn.minsin.excel.model.SheetParseRule;
import cn.minsin.excel.tools.ExcelUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelParseFunctions {
    protected Workbook workbook;
    protected List<SheetParseRule> sheetRules = new ArrayList<SheetParseRule>(2);

    public ExcelParseFunctions init(InputStream inputStream) throws IOException {
        this.workbook = ExcelUtil.parseInputStreamToWorkBook(inputStream);
        return this;
    }

    public ExcelParseFunctions init(File file) throws IOException {
        this.workbook = ExcelUtil.parseFileToWorkBook(file);
        return this;
    }

    public static ExcelParseFunctions initByFile(File file) throws IOException {
        return new ExcelParseFunctions().init(file);
    }

    public static ExcelParseFunctions initByInputStream(InputStream inputStream) throws IOException {
        return new ExcelParseFunctions().init(inputStream);
    }

    public ExcelParseFunctions addSheetRules(SheetParseRule parseSheetRule) {
        this.sheetRules.add(parseSheetRule);
        return this;
    }

    public ExcelParseFunctions addSheetRules(List<SheetParseRule> parseSheetRule) {
        this.sheetRules.addAll(parseSheetRule);
        return this;
    }

    public ExcelParseFunctions addSheetRules(SheetParseRule ... parseSheetRule) {
        for (SheetParseRule sheetParseRule : parseSheetRule) {
            this.addSheetRules(sheetParseRule);
        }
        return this;
    }

    public ExcelParseResultModel parse() {
        ExcelParseResultModel excelParseResultModel = new ExcelParseResultModel();
        MutilsException.throwException((boolean)this.sheetRules.isEmpty(), (String)"\u5fc5\u987b\u8981\u586b\u5199sheet\u89e3\u6790\u89c4\u5219");
        for (SheetParseRule rows : this.sheetRules) {
            int sheetIndex = rows.getSheetIndex();
            Sheet aimSheet = this.workbook.getSheetAt(sheetIndex);
            ExcelSheetModel excelSheetModel = new ExcelSheetModel();
            excelSheetModel.setSheetName(aimSheet.getSheetName());
            excelSheetModel.setSheetIndex(sheetIndex);
            int lastRowNum = aimSheet.getLastRowNum();
            for (int i = rows.getParseRowRule().getStartRowIndex(); i <= lastRowNum; ++i) {
                Row next = aimSheet.getRow(i);
                if (next == null) continue;
                ExcelRowModel excelRowModel = new ExcelRowModel();
                excelRowModel.setRowIndex(next.getRowNum());
                for (int needCell : rows.getParseRowRule().getParseCellIndexes()) {
                    Cell cell = next.getCell(needCell);
                    if (cell == null) continue;
                    excelRowModel.addCells(new ExcelCellModel(needCell, cell));
                }
                excelSheetModel.addRows(excelRowModel);
            }
            excelParseResultModel.addSheet(excelSheetModel);
        }
        return excelParseResultModel;
    }
}

