/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.function;

import cn.minsin.excel.enums.ExcelVersion;
import cn.minsin.excel.function.creator.BaseCreator;
import cn.minsin.excel.function.creator.GetWorkbook;
import cn.minsin.excel.function.creator.SheetCreator;
import cn.minsin.excel.tools.ExcelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelCreateFunctions
extends BaseCreator
implements GetWorkbook {
    private ExcelCreateFunctions(Workbook workbook, ExcelVersion excelVersion) {
        super(workbook, excelVersion);
    }

    public ExcelCreateFunctions() {
        super(null, null);
    }

    public static ExcelCreateFunctions initByVersion(ExcelVersion excelVersion) {
        return new ExcelCreateFunctions().init(excelVersion);
    }

    public static ExcelCreateFunctions initByInputStream(InputStream in) throws IOException {
        return new ExcelCreateFunctions().init(in);
    }

    public static ExcelCreateFunctions initByTemplatePath(String templatePath, boolean isInDisk) throws IOException {
        return new ExcelCreateFunctions().init(templatePath, isInDisk);
    }

    public ExcelCreateFunctions init(@NonNull ExcelVersion excelVersion) {
        if (excelVersion == null) {
            throw new NullPointerException("excelVersion");
        }
        this.workbook = excelVersion.createInstance();
        this.excelVersion = excelVersion;
        return this;
    }

    public ExcelCreateFunctions init(InputStream in) throws IOException {
        this.workbook = WorkbookFactory.create((InputStream)in);
        this.excelVersion = ExcelVersion.checkVersion(this.workbook);
        return this;
    }

    public ExcelCreateFunctions init(String templatePath, boolean isInDisk) throws IOException {
        InputStream excelTemplate = ExcelUtil.getExcelTemplate(templatePath, isInDisk);
        return this.init(excelTemplate);
    }

    public SheetCreator createSheet(int index, String name) {
        return this.createSheet(index, name, 0);
    }

    public SheetCreator createSheet(int index, String name, int startRowIndex) {
        Sheet sheet;
        try {
            sheet = this.workbook.getSheetAt(index);
        }
        catch (Exception e) {
            sheet = this.workbook.createSheet(name);
        }
        return new SheetCreator(sheet, this, startRowIndex);
    }

    public ExcelCreateFunctions workbookConsumer(Consumer<Workbook> consumer) {
        consumer.accept(this.workbook);
        return this;
    }

    @Override
    public String getVersionSuffix() {
        return this.excelVersion.getSuffix();
    }
}

