/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.enums;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public enum ExcelVersion {
    VERSION_2003(".xls", HSSFWorkbook.class),
    VERSION_2007(".xlsx", XSSFWorkbook.class),
    VERSION_MORE_THAN_5000(".xlsx", SXSSFWorkbook.class);

    private final String suffix;
    private final Class<?> clazz;

    public static ExcelVersion checkVersion(Workbook workbook) {
        return workbook instanceof HSSFWorkbook ? VERSION_2003 : (workbook instanceof XSSFWorkbook ? VERSION_2007 : VERSION_MORE_THAN_5000);
    }

    public Workbook createInstance() {
        try {
            return (Workbook)this.getClazz().newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private ExcelVersion(String suffix, Class<?> clazz) {
        this.suffix = suffix;
        this.clazz = clazz;
    }
}

