package cn.minsin.excel.model.create;

import cn.minsin.excel.function.ExcelCreateFunctions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: minton.zhang
 * @since: 2020/4/8 23:28
 */
public interface ExcelCreator {


    default void create(ExcelCreateFunctions excelCreateFunctions, int rowIndex) throws IllegalAccessException {
        ExcelCreateFunctions row = excelCreateFunctions.row(rowIndex);
        List<FiledParse> parse = this.parse();
        for (int i = 0; i < parse.size(); i++) {
            row.cell(i, parse.get(i).getValue());
        }
    }

    default List<FiledParse> parse() throws IllegalAccessException {
        List<FiledParse> filedParses = new ArrayList<>();
        Field[] declaredFields = this.getClass().getDeclaredFields();
        for (Field declaredField : declaredFields) {
            CellTitle annotation = declaredField.getAnnotation(CellTitle.class);
            if (annotation == null) {
                continue;
            }
            declaredField.setAccessible(true);
            Object o = declaredField.get(this);
            filedParses.add(new FiledParse(annotation, o));
        }
        return filedParses;
    }

}
