package cn.minsin.excel.config;

import cn.minsin.core.constant.MutilsModelConstant;
import cn.minsin.core.init.AbstractConfig;
import cn.minsin.excel.tools.ExcelUtil;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.InputStream;

/**
 * excel配置文件
 *
 * @author mintonzhang
 * @date 2019年2月14日
 * @since 0.1.0
 */
@Getter
@Setter
@ConfigurationProperties(prefix = MutilsModelConstant.MUTILS_PREFIX + ".excel")
public class MutilsExcelProperties extends AbstractConfig {

    /**
     * excel统一错误模板路径<br/>
     * <p>以classpath:开头 将会在resource下寻找模板文件，必须要将模板放在一个文件夹内,不能直接放在resource下</p>
     * <p>以路径开头:将会在本地磁盘内寻找</p>
     */
    private String errorTemplatePath;

    /**
     * 开始解析的sheet下标
     */
    private int errorTemplateSheetIndex = 0;

    /**
     * 开始解析的row下标
     */
    private int errorTemplateRowIndex = 0;

    /**
     * 开始解析的cell下标
     */
    private int errorTemplateCellIndex = 0;

    /**
     * 输出文件名
     */
    private String errorTemplateExportName = "错误概要";

    @NestedConfigurationProperty
    private InputStream inputStream;

    @Override
    protected void checkConfig() {
        try {
            boolean isInResource = errorTemplatePath.startsWith("classpath:");
            this.inputStream = ExcelUtil.getExcelTemplate(isInResource ? errorTemplatePath.replaceFirst("classpath:", "") : errorTemplatePath, !isInResource);
        } catch (Exception e) {
            this.inputStream = null;
        }
    }
}
