/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.ExcelConfig;
import cn.minsin.core.rule.FunctionRule;
import cn.minsin.core.tools.StringUtil;
import cn.minsin.excel.model.ExcelRowModel;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelFunctions
extends FunctionRule {
    private ExcelVersion excelVersion;
    private Workbook workbook;
    private Row row;
    private Sheet sheet;

    private ExcelFunctions(ExcelVersion excelVersion) {
        int year = excelVersion.getYear();
        if (year == 2003) {
            this.workbook = new HSSFWorkbook();
        } else if (year == 2007) {
            this.workbook = new XSSFWorkbook();
        }
        this.excelVersion = excelVersion;
    }

    private ExcelFunctions(ExcelVersion excelVersion, Workbook workbook) {
        this.excelVersion = excelVersion;
        this.workbook = workbook;
    }

    public static ExcelFunctions builder(ExcelVersion excelVersion) {
        return new ExcelFunctions(excelVersion);
    }

    public static ExcelFunctions builder(InputStream in) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)in);
            return new ExcelFunctions(workbook instanceof HSSFWorkbook ? ExcelVersion.VERSION_2003 : ExcelVersion.VERSION_2007, workbook);
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e, "Excel\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public static ExcelFunctions builder(InputStream in, ExcelVersion excelVersion) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)in);
            return new ExcelFunctions(excelVersion, workbook);
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e, "Excel\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public static Workbook builderCustomize(InputStream in) throws Exception {
        try {
            return WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e, "Excel\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public ExcelFunctions version(ExcelVersion excelVersion) {
        this.excelVersion = excelVersion;
        return this;
    }

    public Workbook getWorkBook() {
        return this.workbook;
    }

    public ExcelVersion getVersion() {
        return this.excelVersion;
    }

    public void export(String filename) throws MutilsErrorException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(filename + this.excelVersion.getSuffix());
            this.workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
            this.workbook.close();
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "Excel\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public void export(HttpServletResponse resp, String fileName) throws MutilsErrorException {
        try {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1") + this.excelVersion.getSuffix();
            resp.setCharacterEncoding("utf-8");
            resp.setContentType("application/x-msdownload; charset=utf-8");
            resp.setHeader("content-disposition", "attachment;filename=" + fileName);
            this.workbook.write((OutputStream)resp.getOutputStream());
            this.workbook.close();
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e, "Excel\u8bfb\u53d6\u5931\u8d25\uff01");
        }
    }

    public ExcelFunctions sheet(int sheetnum) {
        try {
            this.sheet = this.workbook.getSheetAt(sheetnum);
        }
        catch (Exception e) {
            this.sheet = this.workbook.createSheet();
            this.workbook.setActiveSheet(sheetnum);
        }
        return this;
    }

    public ExcelFunctions sheet(int sheetnum, String name) {
        try {
            this.sheet = this.workbook.getSheetAt(sheetnum);
        }
        catch (Exception e) {
            this.sheet = this.workbook.createSheet(name);
            this.workbook.setActiveSheet(sheetnum);
        }
        return this;
    }

    public ExcelFunctions row(int rownum) {
        this.row = null;
        this.row = this.sheet.getRow(rownum);
        if (this.row == null) {
            this.row = this.sheet.createRow(rownum);
        }
        return this;
    }

    public ExcelFunctions cell(int index, Object value) {
        Cell cell = null;
        try {
            cell = this.row.getCell(index);
            cell.setCellType(CellType.STRING);
        }
        catch (Exception e) {
            cell = this.row.createCell(index, CellType.STRING);
        }
        if (value == null) {
            cell.setCellValue("");
            return this;
        }
        if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else {
            cell.setCellValue(value.toString());
        }
        return this;
    }

    public Map<String, ExcelRowModel> getCellValueList(String[] sheetNames, int startRowIndex, int[] cellIndex) throws MutilsErrorException {
        HashMap<String, ExcelRowModel> returnMap = new HashMap<String, ExcelRowModel>();
        for (String name : sheetNames) {
            int index = 0;
            Sheet aimSheet = this.workbook.getSheet(name);
            Iterator rowIterator = aimSheet.rowIterator();
            ExcelRowModel list = new ExcelRowModel();
            while (rowIterator.hasNext()) {
                HashMap<Integer, Object> cells = new HashMap<Integer, Object>();
                Row next = (Row)rowIterator.next();
                if (index < startRowIndex) {
                    ++index;
                    continue;
                }
                boolean isAllNull = true;
                for (int i : cellIndex) {
                    String value = ExcelFunctions.getCellRealValue(next.getCell(i));
                    if (value != null) {
                        isAllNull = false;
                    }
                    cells.put(i, value);
                }
                if (isAllNull) continue;
                list.setCells(cells);
            }
            returnMap.put(name, list);
        }
        return returnMap;
    }

    public static String getCellRealValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        String cellValue = "";
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    cellValue = sdf.format(DateUtil.getJavaDate((double)cell.getNumericCellValue())).toString();
                    break;
                }
                DataFormatter dataFormatter = new DataFormatter();
                cellValue = dataFormatter.formatCellValue(cell);
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                cellValue = cell.getCellFormula() + "";
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "\u975e\u6cd5\u5b57\u7b26";
                break;
            }
            default: {
                cellValue = "\u672a\u77e5\u7c7b\u578b";
            }
        }
        return StringUtil.filterSpace((String)cellValue);
    }

    public static void error(HttpServletResponse resp, String message, Exception error) throws MutilsException {
        try {
            String errorTemplateUrl = ExcelConfig.excelConfig.getErrorTemplatePath();
            String errorMessage = error == null ? "" : error.getMessage();
            ExcelFunctions.builder(new FileInputStream(errorTemplateUrl)).sheet(ExcelConfig.excelConfig.getErrorTemplateSheetIndex()).row(ExcelConfig.excelConfig.getErrorTemplateRowIndex()).cell(ExcelConfig.excelConfig.getErrorTemplateCellIndex(), message + "\n\n" + errorMessage).export(resp, ExcelConfig.excelConfig.getErrorTemplateExportName());
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e, "\u9519\u8bef\u6a21\u677f\u8bfb\u53d6\u5931\u8d25");
        }
    }

    public static InputStream getExcelTempalte(String excelName) {
        InputStream inStream = ExcelFunctions.class.getClassLoader().getResourceAsStream(excelName);
        if (inStream == null) {
            throw new MutilsException(excelName + " \u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728.");
        }
        return inStream;
    }

    public static enum ExcelVersion {
        VERSION_2003(".xls", 2003),
        VERSION_2007(".xlsx", 2007);

        private String suffix;
        private int year;

        public String getSuffix() {
            return this.suffix;
        }

        private ExcelVersion(String suffix, int year) {
            this.suffix = suffix;
            this.year = year;
        }

        public int getYear() {
            return this.year;
        }
    }
}

