/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.excel.config;

import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.AbstractConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="mutils.excel")
public class MutilsExcelProperties
extends AbstractConfig {
    private String errorTemplatePath;
    private int errorTemplateSheetIndex = 0;
    private int errorTemplateRowIndex = 0;
    private int errorTemplateCellIndex = 0;
    private String errorTemplateExportName = "\u9519\u8bef\u6982\u8981";
    @NestedConfigurationProperty
    private InputStream inputStream;

    protected void checkConfig() {
        slog.info("Required for initialization errorTemplatePath,and this file must exists.");
        MutilsException.throwException((this.errorTemplatePath == null ? 1 : 0) != 0, (String)"errorTemplatePath must not be null.");
        if (this.errorTemplatePath.startsWith("/")) {
            InputStream inStream = MutilsExcelProperties.class.getClassLoader().getResourceAsStream(this.errorTemplatePath.replaceFirst("/", ""));
            MutilsException.throwException((inStream == null ? 1 : 0) != 0, (String)"errorTemplatePath not exists.");
            this.inputStream = inStream;
        } else {
            File file = new File(this.errorTemplatePath);
            MutilsException.throwException((!file.exists() ? 1 : 0) != 0, (String)"errorTemplatePath not exists.");
            try {
                this.inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public String getErrorTemplatePath() {
        return this.errorTemplatePath;
    }

    public int getErrorTemplateSheetIndex() {
        return this.errorTemplateSheetIndex;
    }

    public int getErrorTemplateRowIndex() {
        return this.errorTemplateRowIndex;
    }

    public int getErrorTemplateCellIndex() {
        return this.errorTemplateCellIndex;
    }

    public String getErrorTemplateExportName() {
        return this.errorTemplateExportName;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setErrorTemplatePath(String errorTemplatePath) {
        this.errorTemplatePath = errorTemplatePath;
    }

    public void setErrorTemplateSheetIndex(int errorTemplateSheetIndex) {
        this.errorTemplateSheetIndex = errorTemplateSheetIndex;
    }

    public void setErrorTemplateRowIndex(int errorTemplateRowIndex) {
        this.errorTemplateRowIndex = errorTemplateRowIndex;
    }

    public void setErrorTemplateCellIndex(int errorTemplateCellIndex) {
        this.errorTemplateCellIndex = errorTemplateCellIndex;
    }

    public void setErrorTemplateExportName(String errorTemplateExportName) {
        this.errorTemplateExportName = errorTemplateExportName;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

