package cn.minsin.dianwoda.code;

/**
 * 全国地区编码表
 *
 * @author minsin
 */
public enum CityCode {
    C330100("杭州市", "330100"), C320100("南京市", "320100"), C310100("上海市", "310100"), C420100("武汉市", "420100"),
    C370100("济南市", "370100"), C410100("郑州市", "410100"), C430100("长沙市", "430100"), C510100("成都市", "510100"),
    C440300("深圳市", "440300"), C610100("西安市", "610100"), C500100("重庆市", "500100"), C110100("北京市", "110100"),
    C370200("青岛市", "370200"), C120100("天津市", "120100"), C350200("厦门市", "350200"), C330300("温州市", "330300"),
    C330200("宁波市", "330200"), C350100("福州市", "350100"), C440100("广州市", "440100"), C320500("苏州市", "320500"),
    C320200("无锡市", "320200"), C320400("常州市", "320400"), C441900("东莞市", "441900"), C440600("佛山市", "440600"),
    C340100("合肥市", "340100"), C371300("临沂市", "371300"), C330600("绍兴市", "330600"), C130100("石家庄市", "130100"),
    C130600("保定市", "130600"), C330700("金华市", "330700"), C440500("汕头市", "440500"), C360400("九江市", "360400"),
    C440400("珠海市", "440400"), C360100("南昌市", "360100"), C530100("昆明市", "530100"), C320600("南通市", "320600"),
    C340200("芜湖市", "340200"), C450100("南宁市", "450100"), C220100("长春市", "220100"), C321000("扬州市", "321000"),
    C330400("嘉兴市", "330400"), C330500("湖州市", "330500"), C210200("大连市", "210200"), C210100("沈阳市", "210100"),
    C650100("乌鲁木齐市", "650100"), C320300("徐州市", "320300"), C320900("盐城市", "320900"), C321100("镇江市", "321100"),
    C370600("烟台市", "370600"), C371000("威海市", "371000"), C350500("泉州市", "350500"), C441300("惠州市", "441300"),
    C331000("台州市", "331000"), C370700("潍坊市", "370700"), C370300("淄博市", "370300"), C340300("蚌埠市", "340300"),
    C620100("兰州市", "620100"), C140100("太原市", "140100"), C510700("绵阳市", "510700"), C520100("贵阳市", "520100"),
    C460100("海口市", "460100"), C150100("呼和浩特市", "150100"), C810000("香港", "810000"), C620400("白银市", "620400"),
    C621100("定西市", "621100"), C620300("金昌市", "620300"), C620900("酒泉市", "620900"), C620800("平凉市", "620800"),
    C621000("庆阳市", "621000"), C620500("天水市", "620500"), C620700("张掖市", "620700"), C451000("百色市", "451000"),
    C450500("北海市", "450500"), C450800("贵港市", "450800"), C450300("桂林市", "450300"), C451100("贺州市", "451100"),
    C451300("来宾市", "451300"), C450200("柳州市", "450200"), C450700("钦州市", "450700"), C450400("梧州市", "450400"),
    C450900("玉林市", "450900"), C520500("毕节市", "520500"), C520200("六盘水市", "520200"), C520600("铜仁市", "520600"),
    C520300("遵义市", "520300"), C460200("三亚市", "460200"), C230600("大庆市", "230600"), C230100("哈尔滨市", "230100"),
    C230400("鹤岗市", "230400"), C231100("黑河市", "231100"), C230300("鸡西市", "230300"), C230800("佳木斯市", "230800"),
    C231000("牡丹江市", "231000"), C230900("七台河市", "230900"), C230200("齐齐哈尔市", "230200"), C230500("双鸭山市", "230500"),
    C430700("常德市", "430700"), C431000("郴州市", "431000"), C430400("衡阳市", "430400"), C431200("怀化市", "431200"),
    C431300("娄底市", "431300"), C430500("邵阳市", "430500"), C430300("湘潭市", "430300"), C430900("益阳市", "430900"),
    C431100("永州市", "431100"), C430600("岳阳市", "430600"), C430800("张家界市", "430800"), C430200("株洲市", "430200"),
    C433100("湘西土家族苗族自治州", "433100"), C220800("白城市", "220800"), C220600("白山市", "220600"), C220200("吉林市", "220200"),
    C220400("辽源市", "220400"), C220300("四平市", "220300"), C220700("松原市", "220700"), C220500("通化市", "220500"),
    C210300("鞍山市", "210300"), C211300("朝阳市", "211300"), C210600("丹东市", "210600"), C210900("阜新市", "210900"),
    C211400("葫芦岛市", "211400"), C210700("锦州市", "210700"), C211000("辽阳市", "211000"), C211100("盘锦市", "211100"),
    C210800("营口市", "210800"), C150200("包头市", "150200"), C150400("赤峰市", "150400"), C150600("鄂尔多斯市", "150600"),
    C150700("呼伦贝尔市", "150700"), C150500("通辽市", "150500"), C150300("乌海市", "150300"), C150900("乌兰察布市", "150900"),
    C640200("石嘴山市", "640200"), C640300("吴忠市", "640300"), C640100("银川市", "640100"), C630100("西宁市", "630100"),
    C610900("安康市", "610900"), C610300("宝鸡市", "610300"), C610700("汉中市", "610700"), C610200("铜川市", "610200"),
    C610500("渭南市", "610500"), C610600("延安市", "610600"), C610800("榆林市", "610800"), C511700("达州市", "511700"),
    C510600("德阳市", "510600"), C511600("广安市", "511600"), C510800("广元市", "510800"), C511100("乐山市", "511100"),
    C510500("泸州市", "510500"), C511300("南充市", "511300"), C511000("内江市", "511000"), C510400("攀枝花市", "510400"),
    C510900("遂宁市", "510900"), C511500("宜宾市", "511500"), C510300("自贡市", "510300"), C530500("保山市", "530500"),
    C532300("楚雄彝族自治州", "532300"), C532900("大理白族自治州", "532900"), C532500("红河哈尼族彝族自治州", "532500"),
    C530700("丽江市", "530700"), C530300("曲靖市", "530300"), C532800("西双版纳傣族自治州", "532800"), C530400("玉溪市", "530400"),
    C530600("昭通市", "530600"), C460400("儋州市", "460400"), C532600("文山壮族苗族自治州", "532600"), C513400("凉山彝族自治州", "513400"),
    C222400("延边朝鲜族自治州", "222400"), C340800("安庆市", "340800"), C341600("亳州市", "341600"), C341700("池州市", "341700"),
    C341100("滁州市", "341100"), C341200("阜阳市", "341200"), C340600("淮北市", "340600"), C340400("淮南市", "340400"),
    C341000("黄山市", "341000"), C341500("六安市", "341500"), C340500("马鞍山市", "340500"), C340700("铜陵市", "340700"),
    C341300("宿州市", "341300"), C341800("宣城市", "341800"), C350800("龙岩市", "350800"), C350700("南平市", "350700"),
    C350900("宁德市", "350900"), C350300("莆田市", "350300"), C350400("三明市", "350400"), C445100("潮州市", "445100"),
    C441600("河源市", "441600"), C440700("江门市", "440700"), C445200("揭阳市", "445200"), C440900("茂名市", "440900"),
    C441400("梅州市", "441400"), C441800("清远市", "441800"), C441500("汕尾市", "441500"), C440200("韶关市", "440200"),
    C441700("阳江市", "441700"), C445300("云浮市", "445300"), C440800("湛江市", "440800"), C441200("肇庆市", "441200"),
    C130900("沧州市", "130900"), C130800("承德市", "130800"), C131100("衡水市", "131100"), C131000("廊坊市", "131000"),
    C130300("秦皇岛市", "130300"), C130200("唐山市", "130200"), C130500("邢台市", "130500"), C130700("张家口市", "130700"),
    C410500("安阳市", "410500"), C410600("鹤壁市", "410600"), C410800("焦作市", "410800"), C410200("开封市", "410200"),
    C410300("洛阳市", "410300"), C411100("漯河市", "411100"), C410400("平顶山市", "410400"), C410900("濮阳市", "410900"),
    C411200("三门峡市", "411200"), C410700("新乡市", "410700"), C411500("信阳市", "411500"), C411000("许昌市", "411000"),
    C411700("驻马店市", "411700"), C420700("鄂州市", "420700"), C420200("黄石市", "420200"), C420800("荆门市", "420800"),
    C420300("十堰市", "420300"), C421300("随州市", "421300"), C421200("咸宁市", "421200"), C420600("襄阳市", "420600"),
    C420900("孝感市", "420900"), C420500("宜昌市", "420500"), C320800("淮安市", "320800"), C321300("宿迁市", "321300"),
    C361000("抚州市", "361000"), C360800("吉安市", "360800"), C360200("景德镇市", "360200"), C360300("萍乡市", "360300"),
    C361100("上饶市", "361100"), C360500("新余市", "360500"), C360900("宜春市", "360900"), C360600("鹰潭市", "360600"),
    C210500("本溪市", "210500"), C210400("抚顺市", "210400"), C211200("铁岭市", "211200"), C371600("滨州市", "371600"),
    C371400("德州市", "371400"), C370500("东营市", "370500"), C371700("菏泽市", "371700"), C371200("莱芜市", "371200"),
    C371500("聊城市", "371500"), C371100("日照市", "371100"), C370900("泰安市", "370900"), C370400("枣庄市", "370400"),
    C140200("大同市", "140200"), C140500("晋城市", "140500"), C141000("临汾市", "141000"), C141100("吕梁市", "141100"),
    C140600("朔州市", "140600"), C140900("忻州市", "140900"), C140300("阳泉市", "140300"), C140800("运城市", "140800"),
    C140400("长治市", "140400"), C610400("咸阳市", "610400"), C511400("眉山市", "511400"), C512000("资阳市", "512000"),
    C331100("丽水市", "331100"), C330800("衢州市", "330800"), C330900("舟山市", "330900"), C422800("恩施土家族苗族自治州", "422800"),
    C350600("漳州市", "350600"), C442000("中山市", "442000");

    private String cityName;

    private String code;

    private CityCode(String cityName, String code) {
        this.cityName = cityName;
        this.code = code;
    }

    public static String getCodeByAddress(String address) {
        try {
            for (CityCode c : CityCode.values()) {
                if (address.contains(c.getCityName())) {
                    return c.getCode();
                }
            }
        } catch (Exception e) {
        }
        return "330100"; // 默认杭州
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
