/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.dianwoda.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class SignUtil {
    public static String sign(Map<String, Object> paramValues, String secret) {
        try {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> paramNames = new ArrayList<String>(paramValues.size());
            paramNames.addAll(paramValues.keySet());
            Collections.sort(paramNames);
            sb.append(secret);
            paramNames.forEach(paramName -> sb.append((String)paramName).append(paramValues.get(paramName)));
            sb.append(secret);
            System.out.println("\u5f97\u5230\u7684\u52a0\u5bc6\u524d\u6587\u6bb5\uff1a" + sb);
            byte[] sha1Digest = SignUtil.getSHA1Digest(sb.toString());
            System.out.println("\u5f97\u5230\u7684\u7b7e\u540d\uff1a" + SignUtil.byte2hex(sha1Digest));
            return SignUtil.byte2hex(sha1Digest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getSHA1Digest(String data) throws IOException {
        byte[] bytes;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            bytes = md.digest(data.getBytes("utf-8"));
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }
}

