/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.base;

import cn.minsin.core.tools.StringUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;

public class BaseCriteria
extends Criteria
implements CriteriaDefinition {
    private BaseCriteria(String key) {
        super(key);
    }

    public BaseCriteria() {
    }

    public static BaseCriteria where(String key) {
        return new BaseCriteria(key);
    }

    public static boolean exits(Criteria criteria, String key) {
        if (criteria != null && StringUtil.isNotBlank((CharSequence)key)) {
            return criteria.getCriteriaObject().containsKey((Object)key);
        }
        return false;
    }

    public static boolean notExits(Criteria criteria, String key) {
        return !BaseCriteria.exits(criteria, key);
    }

    public BaseCriteria likeEnd(String key) {
        Pattern compile = Pattern.compile("^.*" + key + "$", 2);
        super.regex(compile);
        return this;
    }

    public BaseCriteria likeStart(String key) {
        Pattern compile = Pattern.compile("^" + key + ".*$", 2);
        super.regex(compile);
        return this;
    }

    public BaseCriteria like(String key) {
        Pattern compile = Pattern.compile("^.*" + key + ".*$", 2);
        super.regex(compile);
        return this;
    }

    public BaseCriteria between(Object data1, Object data2, boolean isEqual) {
        if (data1 == null && data2 == null) {
            return this;
        }
        if (isEqual) {
            if (data1 != null) {
                super.gte(data1);
            }
            if (data2 != null) {
                super.lte(data2);
            }
        } else {
            if (data1 != null) {
                super.gt(data1);
            }
            if (data2 != null) {
                super.lt(data2);
            }
        }
        return this;
    }

    public BaseCriteria today() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date todayStart = calendar.getTime();
        calendar.add(5, 1);
        Date endStart = calendar.getTime();
        super.gte((Object)todayStart).lte((Object)endStart);
        return this;
    }

    public BaseCriteria isNotNull() {
        super.ne(null);
        return this;
    }

    public BaseCriteria isNull() {
        super.is(null);
        return this;
    }

    public Document getCriteriaObject() {
        return super.getCriteriaObject();
    }

    public String getKey() {
        return super.getKey();
    }
}

