/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.config;

import cn.minsin.base.BaseRepositoryImpl;
import java.io.Serializable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.mongodb.repository.support.QuerydslMongoPredicateExecutor;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;

public class MutilsRepositoryFactory<S, ID extends Serializable>
extends MongoRepositoryFactory {
    private final MongoOperations mongoOperations;

    public MutilsRepositoryFactory(MongoOperations mongoOperations) {
        super(mongoOperations);
        this.mongoOperations = mongoOperations;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        Class repositoryInterface = information.getRepositoryInterface();
        if (this.isQueryDslRepository(repositoryInterface)) {
            MongoEntityInformation entityInformation = super.getEntityInformation(repositoryInterface);
            return new SimpleMongoRepository(entityInformation, this.mongoOperations);
        }
        return super.getTargetRepository(information);
    }

    private boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslMongoPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return this.isQueryDslRepository(metadata.getRepositoryInterface()) ? super.getRepositoryBaseClass(metadata) : BaseRepositoryImpl.class;
    }
}

