/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.base;

import cn.minsin.annotation.LogicDelete;
import cn.minsin.annotation.PrimaryKey;
import cn.minsin.base.BaseCriteria;
import cn.minsin.base.BaseRepository;
import cn.minsin.base.GroupType;
import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.tools.ListUtil;
import cn.minsin.core.tools.ModelUtil;
import cn.minsin.core.tools.StringUtil;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;

public class BaseRepositoryImpl<T, ID>
extends SimpleMongoRepository<T, ID>
implements BaseRepository<T, ID> {
    final String PLACE_HOLDER = "_obj";
    private final MongoOperations mongotemplate;
    private final MongoEntityInformation<T, ID> entityInformation;

    public BaseRepositoryImpl(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.mongotemplate = mongoOperations;
        this.entityInformation = metadata;
    }

    @Override
    public long updateOne(Query query, Update update) {
        UpdateResult updateFirst = this.mongotemplate.updateFirst(query, update, this.entityInformation.getJavaType());
        return updateFirst.getModifiedCount();
    }

    @Override
    public long updateMany(Query query, Update update) {
        UpdateResult updateMulti = this.mongotemplate.updateMulti(query, update, this.entityInformation.getJavaType());
        return updateMulti.getModifiedCount();
    }

    @Override
    public MongoTemplate getMongotemplate() {
        return (MongoTemplate)this.mongotemplate;
    }

    @Override
    public long delete(Query query) {
        DeleteResult remove = this.mongotemplate.remove(query, this.entityInformation.getJavaType());
        return remove.getDeletedCount();
    }

    @Override
    public List<Object> selectSingleField(Query query, String field) {
        ArrayList<Object> obj = new ArrayList<Object>();
        try {
            List find = this.mongotemplate.find((Query)new BasicQuery(query == null ? new Document() : query.getQueryObject(), new Document().append(field, (Object)true).append("_id", (Object)false)), Map.class, this.entityInformation.getCollectionName());
            find.forEach(e -> {
                Object object = e.get(field);
                if (object != null) {
                    obj.add(object);
                }
            });
            return obj;
        }
        catch (Exception e2) {
            throw new MutilsException((Throwable)e2);
        }
    }

    @Override
    public Page<T> selectAll(Query query, PageRequest pageRequest) {
        Pageable pageable = pageRequest == null ? Pageable.unpaged() : pageRequest;
        query.with(pageable);
        List list = this.mongotemplate.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage((List)list, (Pageable)pageable, () -> this.mongotemplate.count(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public T selectByPrimaryKey(String value) {
        Class javaType = this.entityInformation.getJavaType();
        String id = null;
        Set fields = ModelUtil.getAllFields((Object)javaType);
        for (Field field : fields) {
            PrimaryKey annotation = field.getAnnotation(PrimaryKey.class);
            if (annotation == null) continue;
            id = field.getName();
            break;
        }
        return (T)this.mongotemplate.findOne(new Query((CriteriaDefinition)BaseCriteria.where(id).is(value)), javaType);
    }

    @Override
    public T selectOne(Query query) {
        return (T)this.mongotemplate.findOne(query, this.entityInformation.getJavaType());
    }

    @Override
    public long count(Query query) {
        return this.mongotemplate.count(query, this.entityInformation.getJavaType());
    }

    @Override
    public List<T> selectList(Query query, PageRequest pageRequest) {
        Pageable pageable = pageRequest == null ? Pageable.unpaged() : pageRequest;
        query.with(pageable);
        return this.mongotemplate.find(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
    }

    @Override
    public Page<T> buliderPage(List<T> list, Query query, PageRequest pageRequest) {
        Pageable pageable = pageRequest == null ? Pageable.unpaged() : pageRequest;
        query.with(pageable);
        return PageableExecutionUtils.getPage(list, (Pageable)pageable, () -> this.mongotemplate.count(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }

    @Override
    public long insertSelective(T model, boolean autoPrimaryKey) {
        try {
            Document document = new Document();
            Set fields = ModelUtil.getAllFields(model);
            for (Field field : fields) {
                PrimaryKey annotation;
                if (ModelUtil.verificationField((Field)field)) continue;
                String key = field.getName();
                field.setAccessible(true);
                Object value = field.get(model);
                LogicDelete delete = field.getAnnotation(LogicDelete.class);
                if (delete != null) {
                    value = delete.valid();
                }
                if ((annotation = field.getAnnotation(PrimaryKey.class)) != null) {
                    if (autoPrimaryKey) {
                        value = StringUtil.getUUIDForLength((int)32);
                    }
                    if (key == null || value == null) {
                        throw new MutilsErrorException("@PrimaryKey\u6240\u5c5e\u5b57\u6bb5Value\u4e3a\u7a7a ");
                    }
                    document.put("_id", value);
                    document.put(key, value);
                    continue;
                }
                if (StringUtil.isBlank((Object[])new Object[]{value})) {
                    value = null;
                }
                document.put(key, value);
            }
            this.mongotemplate.insert((Object)document, this.entityInformation.getCollectionName());
            return 1L;
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e);
        }
    }

    @Override
    public long updateByPrimaryKeySelective(T model, boolean Ignore) {
        try {
            Object idValue = null;
            String idkey = null;
            Set fields = ModelUtil.getAllFields(model);
            Update update = new Update();
            for (Field field : fields) {
                if (ModelUtil.verificationField((Field)field)) continue;
                PrimaryKey annotation = field.getAnnotation(PrimaryKey.class);
                String key = field.getName();
                boolean pass = "_id".equals(key) && annotation == null;
                if (pass) continue;
                field.setAccessible(true);
                Object value = field.get(model);
                if (annotation != null && idValue == null && idkey == null) {
                    if (StringUtil.isBlank((Object[])new Object[]{value})) {
                        throw new MutilsErrorException("@PrimaryKey\u6240\u5c5e\u5b57\u6bb5Value\u4e3a\u7a7a");
                    }
                    idValue = value;
                    idkey = key;
                    continue;
                }
                if (StringUtil.isBlank((Object[])new Object[]{value}) && Ignore) continue;
                update.set(key, value);
            }
            UpdateResult updateFirst = this.mongotemplate.updateFirst(new Query((CriteriaDefinition)BaseCriteria.where(idkey).is(idValue)), update, this.entityInformation.getJavaType());
            return updateFirst.getModifiedCount();
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e);
        }
    }

    @Override
    public long logicDeleteByPrimaryKey(T model, boolean logicRealValue) {
        try {
            Set fields = ModelUtil.getAllFields(model);
            Field idField = null;
            Field delField = null;
            Object invalid = 1;
            for (Field field : fields) {
                if (ModelUtil.verificationField((Field)field)) continue;
                PrimaryKey annotation = field.getAnnotation(PrimaryKey.class);
                if (annotation != null) {
                    idField = field;
                    continue;
                }
                LogicDelete delete = field.getAnnotation(LogicDelete.class);
                if (delete != null) {
                    delField = field;
                    if (logicRealValue) {
                        delField.setAccessible(true);
                        invalid = delField.get(model);
                        if (!StringUtil.isBlank((Object[])new Object[]{invalid})) continue;
                        throw new MutilsErrorException("@LogicDelete\u6240\u5c5e\u5b57\u6bb5Value\u4e3a\u7a7a");
                    }
                    invalid = delete.invalid();
                    continue;
                }
                if (idField == null || delField == null) continue;
                break;
            }
            idField.setAccessible(true);
            Object idValue = idField.get(model);
            if (idValue != null) {
                Update update = new Update();
                update.set(delField.getName(), invalid);
                UpdateResult updateFirst = this.mongotemplate.updateFirst(new Query((CriteriaDefinition)BaseCriteria.where(idField.getName()).is(idValue)), update, this.entityInformation.getJavaType());
                return updateFirst.getModifiedCount();
            }
            return 0L;
        }
        catch (Exception e) {
            throw new MutilsException((Throwable)e);
        }
    }

    @Override
    public <O> O aggregation(Criteria match, String key, String value, Class<O> output, GroupType type) throws MutilsErrorException {
        try {
            Aggregation newAggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)match), this.groupOperation(key, value, type)});
            AggregationResults aggregationResults = this.mongotemplate.aggregate(newAggregation, this.entityInformation.getCollectionName(), Document.class);
            List documentList = aggregationResults.getMappedResults();
            if (!ListUtil.isEmpty((List)documentList)) {
                return (O)((Document)documentList.get(0)).get((Object)"_obj");
            }
            return null;
        }
        catch (Exception e) {
            throw new MutilsErrorException((Throwable)e);
        }
    }

    protected GroupOperation groupOperation(String key1, String key2, GroupType type) {
        Assert.notNull((Object)((Object)type), (String)"GroupType \u4e0d\u80fd\u4e3a\u7a7a");
        switch (type) {
            case AVG: {
                return Aggregation.group((String[])new String[]{key1}).avg(key2).as("_obj");
            }
            case MAX: {
                return Aggregation.group((String[])new String[]{key1}).max(key2).as("_obj");
            }
            case MIN: {
                return Aggregation.group((String[])new String[]{key1}).min(key2).as("_obj");
            }
            case SUM: {
                return Aggregation.group((String[])new String[]{key1}).sum(key2).as("_obj");
            }
            case COUNT: {
                return Aggregation.group((String[])new String[]{key1}).count().as("_obj");
            }
            case FIRST: {
                return Aggregation.group((String[])new String[]{key1}).first(key2).as("_obj");
            }
            case LAST: {
                return Aggregation.group((String[])new String[]{key1}).last(key2).as("_obj");
            }
        }
        return null;
    }
}

