/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.tools.StringUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    public static String date2String(Date date) {
        return DateUtil.date2String(date, DateFormatEnum.yyyy_MM_dd_HH_mm_ss.getFormat());
    }

    public static String date2String(Date date, DateFormatEnum format) {
        return DateUtil.date2String(date, format.getFormat());
    }

    public static String date2String(Date date, String format) {
        if (date == null || StringUtil.isBlank((CharSequence)format)) {
            return null;
        }
        return DateFormatUtils.format((Date)date, (String)format, (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static String date2String(Date date, String format, String defaultValue) {
        try {
            if (StringUtil.isBlank((CharSequence)format)) {
                format = DateFormatEnum.yyyy_MM_dd_HH_mm_ss.getFormat();
            }
            return DateUtil.date2String(date, format);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String long2DateStr(long source) {
        return DateUtil.long2DateStr(source, DateFormatEnum.yyyy_MM_dd_HH_mm_ss.getFormat());
    }

    public static String long2DateStr(long source, DateFormatEnum format) {
        return DateFormatUtils.format((Date)new Date(source), (String)format.getFormat(), (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static String long2DateStr(long source, String format) {
        return DateFormatUtils.format((Date)new Date(source), (String)format, (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static String long2DateStr(long source, String format, String defaultValue) {
        try {
            return DateFormatUtils.format((Date)new Date(source), (String)format, (TimeZone)TimeZone.getTimeZone("GMT+8"));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Date long2Date(long source) {
        return new Date(source);
    }

    public static Date string2Date(String source, String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DateFormatEnum.yyyy_MM_dd_HH_mm_ss.getFormat();
        }
        try {
            return DateUtils.parseDate((String)source, (String[])new String[]{format});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date string2Date(String source, DateFormatEnum format) {
        try {
            return DateUtils.parseDate((String)source, (String[])new String[]{format.getFormat()});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String transform(String origin, String formater, String formatTo) {
        try {
            Date tmp = DateUtil.string2Date(origin, formater);
            return DateUtil.date2String(tmp, formatTo);
        }
        catch (Exception e) {
            return origin;
        }
    }

    public static String getCurrentDate() {
        return DateUtil.date2String(new Date(), DateFormatEnum.yyyy_MM_dd);
    }

    public static enum DateFormatEnum {
        yyyy_MM_dd_HH_mm_ss("yyyy-MM-dd HH:mm:ss"),
        yyyyMMddHHmmss("yyyyMMddHHmmss"),
        yyyy_MM_dd("yyyy-MM-dd"),
        yyyyMMdd("yyyyMMdd"),
        yyyy_MM_dd_HH_mm("yyyy-MM-dd HH:mm");

        private String format;

        private DateFormatEnum(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

