/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.core.tools;

import cn.minsin.core.tools.StringUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil
extends DateUtils {
    private static final String[] DATE_FORMAT = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyyMMddHHmmss", "yyyy-MM-dd", "yyyyMMdd", "yyyy-MM-dd HH:mm"};

    public static String transform2Standard(String origin) {
        try {
            Date tmp = DateUtil.string2Date(origin);
            return DateUtil.date2String(tmp, 0);
        }
        catch (Exception exception) {
            return origin;
        }
    }

    public static String transform2Standard(String origin, String format) {
        try {
            if (StringUtils.isNotBlank((CharSequence)format)) {
                Date tmp = DateUtils.parseDate((String)origin, (Locale)Locale.CHINA, (String[])new String[]{format});
                return DateUtil.date2String(tmp, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DateUtil.transform2Standard(origin);
        return origin;
    }

    public static String transform(String origin, String formatTo) {
        try {
            Date tmp = DateUtil.string2Date(origin);
            return DateUtil.date2String(tmp, formatTo);
        }
        catch (Exception exception) {
            return origin;
        }
    }

    public static String transform(String origin, String formater, String formatTo) {
        try {
            Date tmp = DateUtil.string2Date(origin, formater);
            return DateUtil.date2String(tmp, formatTo);
        }
        catch (Exception exception) {
            return origin;
        }
    }

    public static String date2String(Date date) {
        return DateUtil.date2String(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String date2String(Date date, int formatIndex) {
        return DateFormatUtils.format((Date)date, (String)DATE_FORMAT[formatIndex], (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static String date2String(Date date, String format) {
        return DateFormatUtils.format((Date)date, (String)format, (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static String date2String(Date date, String format, String defaultValue) {
        try {
            if (StringUtil.isBlank((CharSequence)format)) {
                format = DATE_FORMAT[0];
            }
            return DateUtil.date2String(date, format);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String long2DateStr(long source) {
        return DateUtil.long2DateStr(source, "yyyy-MM-dd HH:mm:ss");
    }

    public static String long2DateStr(long source, int formatIndex) {
        return DateFormatUtils.format((Date)new Date(source), (String)DATE_FORMAT[formatIndex], (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static String long2DateStr(long source, String format) {
        return DateFormatUtils.format((Date)new Date(source), (String)format, (TimeZone)TimeZone.getTimeZone("GMT+8"));
    }

    public static Date long2Date(long source) {
        return new Date(source);
    }

    public static Date string2Date(String source, String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DATE_FORMAT[0];
        }
        try {
            return DateUtils.parseDate((String)source, (String[])new String[]{format});
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date string2Date(String source) throws ParseException {
        return DateUtils.parseDate((String)source, (Locale)Locale.CHINA, (String[])DATE_FORMAT);
    }

    public static Date string2Date(String source, int formatindex) {
        try {
            String format = DATE_FORMAT[formatindex];
            return DateUtils.parseDate((String)source, (String[])new String[]{format});
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Integer compareDate(Object date1, Object date2) {
        try {
            Date d2;
            Date d1;
            Date date = date1 instanceof Date ? (Date)date1 : (d1 = date1 instanceof String ? DateUtil.string2Date((String)date1) : null);
            Date date3 = date2 instanceof Date ? (Date)date2 : (d2 = date2 instanceof String ? DateUtil.string2Date((String)date2) : null);
            if (d1 == null || d2 == null) {
                return -1;
            }
            int r = d1.before(d2) ? 0 : 1;
            return r;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isSameDate(Object date1, Object date2, String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DATE_FORMAT[2];
        }
        try {
            String date1Str;
            String string = date1 instanceof Date ? DateUtil.date2String((Date)date1, format) : (date1Str = date1 instanceof String ? DateUtil.transform(date1.toString(), format) : null);
            String date2Str = date2 instanceof Date ? DateUtil.date2String((Date)date2, format) : (date2 instanceof String ? DateUtil.transform(date2.toString(), format) : null);
            return date1Str.equals(date2Str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }
}

